/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.util;

import de.carne.filescanner.engine.format.AttributeFormatter;

public final class HexFormat {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final AttributeFormatter<Byte> BYTE_FORMATTER = HexFormat::formatByte;
    public static final AttributeFormatter<byte[]> BYTE_ARRAY_FORMATTER = HexFormat::formatByteArray;
    public static final AttributeFormatter<Short> SHORT_FORMATTER = HexFormat::formatShort;
    public static final AttributeFormatter<short[]> SHORT_ARRAY_FORMATTER = HexFormat::formatShortArray;
    public static final AttributeFormatter<Integer> INT_FORMATTER = HexFormat::formatInt;
    public static final AttributeFormatter<int[]> INT_ARRAY_FORMATTER = HexFormat::formatIntArray;
    public static final AttributeFormatter<Long> LONG_FORMATTER = HexFormat::formatLong;
    public static final AttributeFormatter<long[]> LONG_ARRAY_FORMATTER = HexFormat::formatLongArray;

    private HexFormat() {
    }

    public static StringBuilder formatByte(StringBuilder buffer, byte value) {
        buffer.append(HEX_CHARS[value >> 4 & 0xF]);
        buffer.append(HEX_CHARS[value & 0xF]);
        buffer.append('h');
        return buffer;
    }

    public static String formatByte(byte value) {
        return HexFormat.formatByte(new StringBuilder(), value).toString();
    }

    public static StringBuilder formatByteArray(StringBuilder buffer, byte[] value) {
        buffer.append('{');
        boolean firstElement = true;
        for (byte valueElement : value) {
            if (firstElement) {
                firstElement = false;
                buffer.append(' ');
            } else {
                buffer.append(", ");
            }
            HexFormat.formatByte(buffer, valueElement);
        }
        buffer.append(" }");
        return buffer;
    }

    public static String formatByteArray(byte[] value) {
        return HexFormat.formatByteArray(new StringBuilder(), value).toString();
    }

    public static StringBuilder formatShort(StringBuilder buffer, short value) {
        buffer.append(HEX_CHARS[value >> 12 & 0xF]);
        buffer.append(HEX_CHARS[value >> 8 & 0xF]);
        buffer.append(HEX_CHARS[value >> 4 & 0xF]);
        buffer.append(HEX_CHARS[value & 0xF]);
        buffer.append('h');
        return buffer;
    }

    public static String formatShort(short value) {
        return HexFormat.formatShort(new StringBuilder(), value).toString();
    }

    public static StringBuilder formatShortArray(StringBuilder buffer, short[] value) {
        buffer.append('{');
        boolean firstElement = true;
        for (short valueElement : value) {
            if (firstElement) {
                firstElement = false;
                buffer.append(' ');
            } else {
                buffer.append(", ");
            }
            HexFormat.formatShort(buffer, valueElement);
        }
        buffer.append(" }");
        return buffer;
    }

    public static String formatShortArray(short[] value) {
        return HexFormat.formatShortArray(new StringBuilder(), value).toString();
    }

    public static StringBuilder formatInt(StringBuilder buffer, int value) {
        buffer.append(HEX_CHARS[value >> 28 & 0xF]);
        buffer.append(HEX_CHARS[value >> 24 & 0xF]);
        buffer.append(HEX_CHARS[value >> 20 & 0xF]);
        buffer.append(HEX_CHARS[value >> 16 & 0xF]);
        buffer.append(HEX_CHARS[value >> 12 & 0xF]);
        buffer.append(HEX_CHARS[value >> 8 & 0xF]);
        buffer.append(HEX_CHARS[value >> 4 & 0xF]);
        buffer.append(HEX_CHARS[value & 0xF]);
        buffer.append('h');
        return buffer;
    }

    public static String formatInt(int value) {
        return HexFormat.formatInt(new StringBuilder(), value).toString();
    }

    public static StringBuilder formatIntArray(StringBuilder buffer, int[] value) {
        buffer.append('{');
        boolean firstElement = true;
        for (int valueElement : value) {
            if (firstElement) {
                firstElement = false;
                buffer.append(' ');
            } else {
                buffer.append(", ");
            }
            HexFormat.formatInt(buffer, valueElement);
        }
        buffer.append(" }");
        return buffer;
    }

    public static String formatIntArray(int[] value) {
        return HexFormat.formatIntArray(new StringBuilder(), value).toString();
    }

    public static StringBuilder formatLong(StringBuilder buffer, long value) {
        buffer.append(HEX_CHARS[(int)(value >> 60 & 0xFL)]);
        buffer.append(HEX_CHARS[(int)(value >> 56 & 0xFL)]);
        buffer.append(HEX_CHARS[(int)(value >> 52 & 0xFL)]);
        buffer.append(HEX_CHARS[(int)(value >> 48 & 0xFL)]);
        buffer.append(HEX_CHARS[(int)(value >> 44 & 0xFL)]);
        buffer.append(HEX_CHARS[(int)(value >> 40 & 0xFL)]);
        buffer.append(HEX_CHARS[(int)(value >> 36 & 0xFL)]);
        buffer.append(HEX_CHARS[(int)(value >> 32 & 0xFL)]);
        buffer.append(HEX_CHARS[(int)(value >> 28 & 0xFL)]);
        buffer.append(HEX_CHARS[(int)(value >> 24 & 0xFL)]);
        buffer.append(HEX_CHARS[(int)(value >> 20 & 0xFL)]);
        buffer.append(HEX_CHARS[(int)(value >> 16 & 0xFL)]);
        buffer.append(HEX_CHARS[(int)(value >> 12 & 0xFL)]);
        buffer.append(HEX_CHARS[(int)(value >> 8 & 0xFL)]);
        buffer.append(HEX_CHARS[(int)(value >> 4 & 0xFL)]);
        buffer.append(HEX_CHARS[(int)(value & 0xFL)]);
        buffer.append('h');
        return buffer;
    }

    public static String formatLong(long value) {
        return HexFormat.formatLong(new StringBuilder(), value).toString();
    }

    public static StringBuilder formatLongArray(StringBuilder buffer, long[] value) {
        buffer.append('{');
        boolean firstElement = true;
        for (long valueElement : value) {
            if (firstElement) {
                firstElement = false;
                buffer.append(' ');
            } else {
                buffer.append(", ");
            }
            HexFormat.formatLong(buffer, valueElement);
        }
        buffer.append(" }");
        return buffer;
    }

    public static String formatLongArray(long[] value) {
        return HexFormat.formatLongArray(new StringBuilder(), value).toString();
    }
}

