/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.util;

import org.eclipse.jdt.annotation.NonNull;

public final class IntHelper {
    private IntHelper() {
    }

    public static int decodeUnsigned(String string) {
        long value = Long.decode(string);
        if (value > 0xFFFFFFFFL) {
            throw new NumberFormatException("Value " + value + " out of range from input " + string);
        }
        return (int)(value & 0xFFFFFFFFFFL);
    }

    public static int[] decodeUnsignedArray(@NonNull String[] stringArray) {
        int length = stringArray.length;
        int[] valueArray = new int[length];
        for (int index = 0; index < length; ++index) {
            valueArray[index] = IntHelper.decodeUnsigned(stringArray[index]);
        }
        return valueArray;
    }

    public static long toUnsignedLong(Number intNumber) {
        long unsignedLong = intNumber instanceof Byte ? Byte.toUnsignedLong(intNumber.byteValue()) : (intNumber instanceof Short ? Short.toUnsignedLong(intNumber.shortValue()) : (intNumber instanceof Integer ? Integer.toUnsignedLong(intNumber.intValue()) : intNumber.longValue()));
        if ((unsignedLong & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("Number exceeds int value range: " + Long.toHexString(unsignedLong));
        }
        return unsignedLong;
    }
}

