/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.util;

import org.eclipse.jdt.annotation.NonNull;

public final class ShortHelper {
    private ShortHelper() {
    }

    public static short decodeUnsigned(String string) {
        int value = Integer.decode(string);
        if (value > 65535) {
            throw new NumberFormatException("Value " + value + " out of range from input " + string);
        }
        return (short)(value & 0xFFFF);
    }

    public static short[] decodeUnsignedArray(@NonNull String[] stringArray) {
        int length = stringArray.length;
        short[] valueArray = new short[length];
        for (int index = 0; index < length; ++index) {
            valueArray[index] = ShortHelper.decodeUnsigned(stringArray[index]);
        }
        return valueArray;
    }

    public static int toUnsignedInt(Number shortNumber) {
        int unsignedInt = shortNumber instanceof Byte ? Byte.toUnsignedInt(shortNumber.byteValue()) : (shortNumber instanceof Short ? Short.toUnsignedInt(shortNumber.shortValue()) : shortNumber.intValue());
        if ((unsignedInt & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("Number exceeds short value range: " + Integer.toHexString(unsignedInt));
        }
        return unsignedInt;
    }
}

