/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.elf;

import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.DWordSpec;
import de.carne.filescanner.engine.format.FormatSpecDefinition;
import de.carne.filescanner.engine.format.QWordSpec;
import de.carne.filescanner.engine.format.WordSpec;
import de.carne.filescanner.engine.transfer.FileScannerResultExportHandler;
import de.carne.filescanner.engine.transfer.FileScannerResultRenderHandler;
import de.carne.filescanner.engine.transfer.handler.McdTransferHandler;
import de.carne.filescanner.engine.transfer.handler.RangeRenderHandler;
import de.carne.filescanner.engine.transfer.handler.RawTransferHandler;
import de.carne.util.Lazy;
import java.net.URL;
import java.util.Objects;

final class ElfFormatSpecDefinition
extends FormatSpecDefinition {
    private Lazy<CompositeSpec> elfFormatSpec = this.resolveLazy("ELF_FORMAT", CompositeSpec.class);
    private Lazy<CompositeSpec> elfHeaderSpec = this.resolveLazy("ELF_HEADER_64", CompositeSpec.class);
    private Lazy<WordSpec> elf64Machine = this.resolveLazy("ELF_MACHINE_64", WordSpec.class);
    private Lazy<DWordSpec> section64Type = this.resolveLazy("SHEADER_TYPE_64", DWordSpec.class);
    private Lazy<QWordSpec> section64Flags = this.resolveLazy("SHEADER_FLAGS_64", QWordSpec.class);
    private Lazy<QWordSpec> section64Offset = this.resolveLazy("SHEADER_OFFSET_64", QWordSpec.class);
    private Lazy<QWordSpec> section64Size = this.resolveLazy("SHEADER_SIZE_64", QWordSpec.class);

    ElfFormatSpecDefinition() {
    }

    @Override
    protected URL getFormatSpecResource() {
        return Objects.requireNonNull(this.getClass().getResource("ELF.formatspec"));
    }

    public CompositeSpec formatSpec() {
        return (CompositeSpec)this.elfFormatSpec.get();
    }

    public CompositeSpec headerSpec() {
        return (CompositeSpec)this.elfHeaderSpec.get();
    }

    public Long section64Offset() {
        int section64TypeValue = (Integer)((DWordSpec)this.section64Type.get()).get();
        return section64TypeValue != 8 ? (Long)((QWordSpec)this.section64Offset.get()).get() : 0L;
    }

    public Long section64Size() {
        int section64TypeValue = (Integer)((DWordSpec)this.section64Type.get()).get();
        return section64TypeValue != 8 ? (Long)((QWordSpec)this.section64Size.get()).get() : 0L;
    }

    public FileScannerResultRenderHandler section64Renderer() {
        int machine = ((Short)((WordSpec)this.elf64Machine.get()).get()).intValue();
        long flags = (Long)((QWordSpec)this.section64Flags.get()).get();
        FileScannerResultRenderHandler renderer = RangeRenderHandler.RENDER_HANDLER;
        if ((flags & 4L) == 4L && machine == 62) {
            renderer = McdTransferHandler.X86B64_TRANSFER;
        }
        return renderer;
    }

    public FileScannerResultExportHandler section64Exporter() {
        int machine = ((Short)((WordSpec)this.elf64Machine.get()).get()).intValue();
        long flags = (Long)((QWordSpec)this.section64Flags.get()).get();
        FileScannerResultExportHandler exporter = RawTransferHandler.APPLICATION_OCTET_STREAM_TRANSFER;
        if ((flags & 4L) == 4L && machine == 62) {
            exporter = McdTransferHandler.X86B64_TRANSFER;
        }
        return exporter;
    }
}

