/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.exe;

import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.DWordSpec;
import de.carne.filescanner.engine.format.FormatSpecDefinition;
import de.carne.filescanner.engine.format.WordSpec;
import de.carne.filescanner.engine.transfer.FileScannerResultExportHandler;
import de.carne.filescanner.engine.transfer.FileScannerResultRenderHandler;
import de.carne.filescanner.engine.transfer.handler.McdTransferHandler;
import de.carne.filescanner.engine.util.IntHelper;
import de.carne.filescanner.engine.util.ShortHelper;
import de.carne.util.Lazy;
import java.net.URL;
import java.util.Objects;

final class ExeFormatSpecDefinition
extends FormatSpecDefinition {
    private Lazy<CompositeSpec> exeFormatSpec = this.resolveLazy("EXE_FORMAT", CompositeSpec.class);
    private Lazy<CompositeSpec> exeHeaderSpec = this.resolveLazy("IMAGE_DOS_HEADER", CompositeSpec.class);
    private Lazy<WordSpec> imageFileMachine = this.resolveLazy("IMAGE_FILE_MACHINE", WordSpec.class);
    private Lazy<WordSpec> stubRelocationCount = this.resolveLazy("STUB_RELOCATION_COUNT", WordSpec.class);
    private Lazy<DWordSpec> stubNextHeaderOffset = this.resolveLazy("NEXT_HEADER_OFFSET", DWordSpec.class);
    private Lazy<DWordSpec> ntSectionCharacteristics = this.resolveLazy("NT_SECTION_CHARACTERISTICS", DWordSpec.class);
    private Lazy<CompositeSpec> genericSeciontSpec = this.resolveLazy("IMAGE_NT_GENERIC_SECTION", CompositeSpec.class);
    private Lazy<CompositeSpec> i386SeciontSpec = this.resolveLazy("IMAGE_NT_I386_SECTION", CompositeSpec.class);
    private Lazy<CompositeSpec> amd64SeciontSpec = this.resolveLazy("IMAGE_NT_AMD64_SECTION", CompositeSpec.class);

    ExeFormatSpecDefinition() {
    }

    @Override
    protected URL getFormatSpecResource() {
        return Objects.requireNonNull(this.getClass().getResource("EXE.formatspec"));
    }

    public CompositeSpec formatSpec() {
        return (CompositeSpec)this.exeFormatSpec.get();
    }

    public CompositeSpec headerSpec() {
        return (CompositeSpec)this.exeHeaderSpec.get();
    }

    public Long stubTextSize() {
        int relocationCount = ShortHelper.toUnsignedInt((Number)((WordSpec)this.stubRelocationCount.get()).get());
        long nextHeaderOffset = IntHelper.toUnsignedLong((Number)((DWordSpec)this.stubNextHeaderOffset.get()).get());
        return nextHeaderOffset - 64L - (long)(relocationCount * 4);
    }

    public FileScannerResultRenderHandler x86b16Renderer() {
        return McdTransferHandler.X86B16_TRANSFER;
    }

    public FileScannerResultExportHandler x86b16Exporter() {
        return McdTransferHandler.X86B16_TRANSFER;
    }

    public FileScannerResultRenderHandler x86b32Renderer() {
        return McdTransferHandler.X86B32_TRANSFER;
    }

    public FileScannerResultExportHandler x86b32Exporter() {
        return McdTransferHandler.X86B32_TRANSFER;
    }

    public FileScannerResultRenderHandler x86b64Renderer() {
        return McdTransferHandler.X86B64_TRANSFER;
    }

    public FileScannerResultExportHandler x86b64Exporter() {
        return McdTransferHandler.X86B64_TRANSFER;
    }

    public CompositeSpec sectionSpec() {
        int characteristics = (Integer)((DWordSpec)this.ntSectionCharacteristics.get()).get();
        CompositeSpec spec = (CompositeSpec)this.genericSeciontSpec.get();
        if ((characteristics & 0x20) == 32) {
            int machine = ShortHelper.toUnsignedInt((Number)((WordSpec)this.imageFileMachine.get()).get());
            switch (machine) {
                case 332: {
                    spec = (CompositeSpec)this.i386SeciontSpec.get();
                    break;
                }
                case 34404: {
                    spec = (CompositeSpec)this.amd64SeciontSpec.get();
                    break;
                }
            }
        }
        return spec;
    }
}

