/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.hfsplus;

import de.carne.filescanner.engine.InsufficientDataException;
import de.carne.filescanner.engine.UnexpectedDataException;
import de.carne.filescanner.engine.input.FileScannerInput;
import de.carne.filescanner.provider.hfsplus.ForkData;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.BiConsumer;

abstract class BTreeFile<K extends Comparable<K>> {
    private static final int MIN_NODE_SIZE = 512;
    private static final int MAX_NODE_SIZE = 32768;
    private static final int HEADER_RECORD_SIZE = 106;
    private final ForkData forkData;
    private int nodeSize = -1;
    private int rootNode = 0;
    private int firstLeafNode = 0;

    protected BTreeFile(ForkData forkData) {
        this.forkData = forkData;
    }

    public ByteBuffer findLeafNode(K key) throws IOException {
        K nodeKey;
        int numRecords;
        if (this.nodeSize < 0) {
            this.processHeaderNode();
        }
        ByteBuffer nodeBuffer = ByteBuffer.allocate(this.nodeSize).order(ByteOrder.BIG_ENDIAN);
        int currentNode = this.rootNode;
        while (currentNode != 0) {
            this.readNode(nodeBuffer, currentNode);
            byte nodeKind = nodeBuffer.get(8);
            if (nodeKind == -1) break;
            if (nodeKind != 0) {
                throw new IOException("Unexpected node kind: " + nodeKind);
            }
            numRecords = Short.toUnsignedInt(nodeBuffer.getShort(10));
            int nextNode = 0;
            for (int recordNumber = 1; recordNumber <= numRecords; ++recordNumber) {
                int recordOffset = Short.toUnsignedInt(nodeBuffer.getShort(this.nodeSize - recordNumber * 2));
                nodeBuffer.position(recordOffset);
                nodeKey = this.getNodeKey(nodeBuffer);
                int nodeValue = nodeBuffer.getInt();
                int comparison = nodeKey.compareTo(key);
                if (comparison <= 0) {
                    nextNode = nodeValue;
                }
                if (comparison >= 0) break;
            }
            currentNode = nextNode;
        }
        ByteBuffer valueBuffer = null;
        if (currentNode != 0) {
            numRecords = Short.toUnsignedInt(nodeBuffer.getShort(10));
            for (int recordNumber = 1; recordNumber <= numRecords; ++recordNumber) {
                int recordOffset = Short.toUnsignedInt(nodeBuffer.getShort(this.nodeSize - recordNumber * 2));
                int recordLength = Short.toUnsignedInt(nodeBuffer.getShort(this.nodeSize - (recordNumber + 1) * 2)) - recordOffset;
                nodeBuffer.position(recordOffset);
                nodeKey = this.getNodeKey(nodeBuffer);
                if (!nodeKey.equals(key)) continue;
                valueBuffer = nodeBuffer.slice();
                valueBuffer.limit(recordLength - (nodeBuffer.position() - recordOffset));
                break;
            }
        }
        if (valueBuffer == null) {
            throw new IOException("Unexpected node key: " + key);
        }
        return valueBuffer;
    }

    public void walkLeafNodes(BiConsumer<K, ByteBuffer> consumer) throws IOException {
        if (this.nodeSize < 0) {
            this.processHeaderNode();
        }
        if (this.firstLeafNode != 0) {
            ByteBuffer nodeBuffer = ByteBuffer.allocate(this.nodeSize).order(ByteOrder.BIG_ENDIAN);
            int currentLeafNode = this.firstLeafNode;
            while (currentLeafNode != 0) {
                this.readNode(nodeBuffer, currentLeafNode);
                int numRecords = Short.toUnsignedInt(nodeBuffer.getShort(10));
                for (int recordNumber = 1; recordNumber <= numRecords; ++recordNumber) {
                    int recordOffset = Short.toUnsignedInt(nodeBuffer.getShort(this.nodeSize - recordNumber * 2));
                    int recordLength = Short.toUnsignedInt(nodeBuffer.getShort(this.nodeSize - (recordNumber + 1) * 2)) - recordOffset;
                    nodeBuffer.position(recordOffset);
                    K nodeKey = this.getNodeKey(nodeBuffer);
                    ByteBuffer valueBuffer = nodeBuffer.slice();
                    valueBuffer.limit(recordLength - (nodeBuffer.position() - recordOffset));
                    consumer.accept(nodeKey, valueBuffer);
                }
                currentLeafNode = nodeBuffer.getInt(0);
            }
        }
    }

    protected abstract K decodeNodeKey(ByteBuffer var1) throws IOException;

    private void processHeaderNode() throws IOException {
        ByteBuffer headerRecordBuffer = ByteBuffer.allocate(106).order(ByteOrder.BIG_ENDIAN);
        FileScannerInput input = this.forkData.blockDevice().input();
        long forkDataStart = this.forkData.position(0L);
        input.read(headerRecordBuffer, forkDataStart);
        if (headerRecordBuffer.hasRemaining()) {
            throw new InsufficientDataException(input, forkDataStart, headerRecordBuffer.capacity(), headerRecordBuffer.position());
        }
        headerRecordBuffer.flip();
        int uncheckedNodSize = Short.toUnsignedInt(headerRecordBuffer.getShort(32));
        if (uncheckedNodSize < 512 || 32768 < uncheckedNodSize) {
            throw new UnexpectedDataException("Unexpected node size", forkDataStart + 32L, uncheckedNodSize);
        }
        this.nodeSize = uncheckedNodSize;
        this.rootNode = headerRecordBuffer.getInt(16);
        this.firstLeafNode = headerRecordBuffer.getInt(24);
    }

    private void readNode(ByteBuffer buffer, int node) throws IOException {
        buffer.clear();
        long nodePosition = this.forkData.position(Integer.toUnsignedLong(node) * (long)this.nodeSize);
        FileScannerInput input = this.forkData.blockDevice().input();
        input.read(buffer, nodePosition);
        if (buffer.hasRemaining()) {
            throw new InsufficientDataException(input, nodePosition, buffer.capacity(), buffer.position());
        }
        buffer.flip();
    }

    private K getNodeKey(ByteBuffer buffer) throws IOException {
        int keyLength = Short.toUnsignedInt(buffer.getShort());
        ByteBuffer keyBuffer = buffer.slice();
        keyBuffer.limit(keyLength);
        buffer.position(buffer.position() + keyLength);
        return this.decodeNodeKey(keyBuffer);
    }
}

