/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.hfsplus;

import de.carne.filescanner.engine.input.FileScannerInput;

final class BlockDevice {
    private final FileScannerInput input;
    private final long blockSize;

    public BlockDevice(FileScannerInput input, long blockSize) {
        this.input = input;
        this.blockSize = blockSize;
    }

    public FileScannerInput input() {
        return this.input;
    }

    public long block(long offset) {
        return offset / this.blockSize;
    }

    public long offset(long block) {
        return Math.max(block * this.blockSize - (this.blockSize - 2560L), 0L);
    }

    public long size(long blockCount) {
        return blockCount * this.blockSize;
    }
}

