/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.hfsplus;

import de.carne.filescanner.engine.input.FileScannerInput;
import de.carne.filescanner.provider.hfsplus.BTreeFile;
import de.carne.filescanner.provider.hfsplus.BlockDevice;
import de.carne.filescanner.provider.hfsplus.CatalogFileKey;
import de.carne.filescanner.provider.hfsplus.ExtentsFile;
import de.carne.filescanner.provider.hfsplus.ForkData;
import de.carne.filescanner.provider.hfsplus.HfsPlusFormat;
import de.carne.util.Strings;
import de.carne.util.SystemProperties;
import de.carne.util.logging.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

class CatalogFile
extends BTreeFile<CatalogFileKey> {
    private final BlockDevice blockDevice;
    private final ExtentsFile extentsFile;

    public CatalogFile(ForkData forkData, ExtentsFile extentsFile) {
        super(forkData);
        this.blockDevice = forkData.blockDevice();
        this.extentsFile = extentsFile;
    }

    public void walkFileTree(Consumer<FileScannerInput> consumer) throws IOException {
        this.walkLeafNodes(new FileTreeConsumer(this.blockDevice, this.extentsFile, consumer));
    }

    @Override
    protected CatalogFileKey decodeNodeKey(ByteBuffer keyBuffer) throws IOException {
        int parentId = keyBuffer.getInt();
        short nameLength = keyBuffer.getShort();
        String name = nameLength > 0 ? StandardCharsets.UTF_16BE.decode(keyBuffer).toString() : "";
        return new CatalogFileKey(parentId, name);
    }

    private static class FileTreeConsumer
    implements BiConsumer<CatalogFileKey, ByteBuffer> {
        private static final Log LOG = new Log();
        private static final boolean DECODE_RESOURCE_FORK = SystemProperties.booleanValue(HfsPlusFormat.class, (String)"DECODE_RESOURCE_FORK", (boolean)false);
        private final BlockDevice blockDevice;
        private final ExtentsFile extentsFile;
        private final Map<Integer, CatalogFileKey> folderCache = new HashMap<Integer, CatalogFileKey>();
        private final Consumer<FileScannerInput> consumer;

        FileTreeConsumer(BlockDevice blockDevice, ExtentsFile extentsFile, Consumer<FileScannerInput> consumer) {
            this.blockDevice = blockDevice;
            this.extentsFile = extentsFile;
            this.consumer = consumer;
        }

        @Override
        public void accept(CatalogFileKey key, ByteBuffer valueBuffer) {
            int recordType = Short.toUnsignedInt(valueBuffer.getShort());
            try {
                switch (recordType) {
                    case 1: {
                        this.processFolder(key, valueBuffer);
                        break;
                    }
                    case 2: {
                        this.processFile(key, valueBuffer);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        LOG.warning("Ignoring unexpected record type {0} for catalog file key ''{1}''", new Object[]{recordType, Strings.encode((CharSequence)key.toString())});
                        break;
                    }
                }
            }
            catch (IOException e) {
                LOG.warning((Throwable)e, "Failed to process catalog file key ''{0}''", new Object[]{Strings.encode((CharSequence)key.toString())});
            }
        }

        private void processFolder(CatalogFileKey key, ByteBuffer valueBuffer) {
            int folderId = valueBuffer.getInt(8);
            if (folderId != 2) {
                this.folderCache.put(folderId, key);
            }
        }

        private void processFile(CatalogFileKey key, ByteBuffer valueBuffer) throws IOException {
            ForkData resourceFork;
            StringBuilder buffer = new StringBuilder();
            this.buildFolderPath(buffer, key.parentId());
            buffer.append(key.name());
            valueBuffer.position(8);
            int fileId = valueBuffer.getInt();
            valueBuffer.position(88);
            ForkData dataFork = this.decodeForkData(fileId, (byte)0, valueBuffer);
            if (dataFork.logicalSize() != 0L) {
                this.consumer.accept(dataFork.map(buffer.toString()));
            }
            if (DECODE_RESOURCE_FORK && (resourceFork = this.decodeForkData(fileId, (byte)-1, valueBuffer)).logicalSize() != 0L) {
                buffer.append(":resourceFork");
                this.consumer.accept(resourceFork.map(buffer.toString()));
            }
        }

        private void buildFolderPath(StringBuilder buffer, int folderId) {
            CatalogFileKey folderKey = this.folderCache.get(folderId);
            if (folderKey != null) {
                this.buildFolderPath(buffer, folderKey.parentId());
                buffer.append(folderKey.name()).append('/');
            }
        }

        private ForkData decodeForkData(int fileId, byte forkType, ByteBuffer valueBuffer) {
            long logicalSize = valueBuffer.getLong();
            valueBuffer.getInt();
            valueBuffer.getInt();
            int[] extents = new int[16];
            for (int extentIndex = 0; extentIndex < extents.length; ++extentIndex) {
                extents[extentIndex] = valueBuffer.getInt();
            }
            return new ForkData(this.blockDevice, fileId, forkType, logicalSize, extents, this.extentsFile);
        }
    }
}

