/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.hfsplus;

import de.carne.filescanner.engine.input.DecodedInputMapper;
import de.carne.filescanner.engine.input.FileScannerInput;
import de.carne.filescanner.provider.hfsplus.BlockDevice;
import de.carne.filescanner.provider.hfsplus.CatalogFile;
import de.carne.filescanner.provider.hfsplus.ExtentsFile;
import de.carne.filescanner.provider.hfsplus.ForkData;
import de.carne.util.logging.Log;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

class HfsPlusInputMapper
extends DecodedInputMapper {
    private static final Log LOG = new Log();
    private final long blockSize;
    private final long extentsFileSize;
    private final int[] extentsFileExtents;
    private final long catalogFileSize;
    private final int[] catalogFileExtents;

    public HfsPlusInputMapper(long blockSize, long extentsFileSize, int[] extentsFileExtents, long catalogFileSize, int[] catalogFileExtents) {
        super("disk image blocks");
        this.blockSize = blockSize;
        this.extentsFileSize = extentsFileSize;
        this.extentsFileExtents = extentsFileExtents;
        this.catalogFileSize = catalogFileSize;
        this.catalogFileExtents = catalogFileExtents;
    }

    @Override
    public List<FileScannerInput> map(FileScannerInput input) throws IOException {
        LinkedList<FileScannerInput> inputs = new LinkedList<FileScannerInput>();
        try {
            BlockDevice blockDevice = new BlockDevice(input, this.blockSize);
            ForkData extentsFileForkData = new ForkData(blockDevice, 3, 0, this.extentsFileSize, this.extentsFileExtents, null);
            ExtentsFile extentsFile = new ExtentsFile(extentsFileForkData);
            ForkData catalogFileForkData = new ForkData(blockDevice, 4, 0, this.catalogFileSize, this.catalogFileExtents, extentsFile);
            CatalogFile catalogFile = new CatalogFile(catalogFileForkData, extentsFile);
            catalogFile.walkFileTree(inputs::add);
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Failed to decode HFS+ file system", new Object[0]);
        }
        return inputs;
    }
}

