/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.jpeg;

import de.carne.filescanner.engine.ValueStreamerFactory;
import de.carne.filescanner.engine.ValueStreamerStatus;
import de.carne.filescanner.engine.format.ByteSpec;
import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.FormatSpecDefinition;
import de.carne.filescanner.engine.format.WordSpec;
import de.carne.filescanner.engine.transfer.FileScannerResultExportHandler;
import de.carne.filescanner.engine.transfer.FileScannerResultRenderHandler;
import de.carne.filescanner.engine.transfer.handler.RawTransferHandler;
import de.carne.util.Lazy;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Objects;

final class JpegFormatSpecDefinition
extends FormatSpecDefinition {
    private Lazy<CompositeSpec> jpegFormatSpec = this.resolveLazy("JPEG_FORMAT", CompositeSpec.class);
    private Lazy<CompositeSpec> jpegHeaderSpec = this.resolveLazy("JPEG_SOI_APP0_MARKER", CompositeSpec.class);
    private Lazy<ByteSpec> xThumbnail = this.resolveLazy("X_THUMBNAIL", ByteSpec.class);
    private Lazy<ByteSpec> yThumbnail = this.resolveLazy("Y_THUMBNAIL", ByteSpec.class);
    private Lazy<WordSpec> genericLength = this.resolveLazy("GENERIC_LENGTH", WordSpec.class);

    JpegFormatSpecDefinition() {
    }

    @Override
    protected URL getFormatSpecResource() {
        return Objects.requireNonNull(this.getClass().getResource("JPEG.formatspec"));
    }

    public CompositeSpec formatSpec() {
        return (CompositeSpec)this.jpegFormatSpec.get();
    }

    public CompositeSpec headerSpec() {
        return (CompositeSpec)this.jpegHeaderSpec.get();
    }

    public FileScannerResultRenderHandler jpegRenderer() {
        return RawTransferHandler.IMAGE_JPEG_TRANSFER;
    }

    public FileScannerResultExportHandler jpegExporter() {
        return RawTransferHandler.IMAGE_JPEG_TRANSFER;
    }

    public Integer app0ThumbnailSize() {
        return Byte.toUnsignedInt((Byte)((ByteSpec)this.xThumbnail.get()).get()) * Byte.toUnsignedInt((Byte)((ByteSpec)this.yThumbnail.get()).get());
    }

    public Integer genericMarkerDataSize() {
        return Short.toUnsignedInt((Short)((WordSpec)this.genericLength.get()).get()) - 2;
    }

    public ValueStreamerFactory sosScanner() {
        return () -> this::streamSos;
    }

    private ValueStreamerStatus streamSos(ByteBuffer buffer) {
        ValueStreamerStatus status = ValueStreamerStatus.FAILED;
        while (buffer.remaining() >= 2 && status != ValueStreamerStatus.COMPLETE) {
            int bufferPosition = buffer.position();
            int markerValue = Short.toUnsignedInt(buffer.getShort());
            if ((markerValue & 0xFF00) == 65280 && markerValue != 65280 && markerValue != 65535 && (markerValue < 65488 || 65495 < markerValue)) {
                buffer.position(bufferPosition);
                status = ValueStreamerStatus.COMPLETE;
                continue;
            }
            buffer.position(bufferPosition + 1);
            status = ValueStreamerStatus.STREAMING;
        }
        return status;
    }
}

