/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.png;

import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.DWordSpec;
import de.carne.filescanner.engine.format.FormatSpecDefinition;
import de.carne.filescanner.engine.transfer.FileScannerResultExportHandler;
import de.carne.filescanner.engine.transfer.FileScannerResultRenderHandler;
import de.carne.filescanner.engine.transfer.handler.RawTransferHandler;
import de.carne.util.Lazy;
import java.net.URL;
import java.util.Objects;

final class PngFormatSpecDefinition
extends FormatSpecDefinition {
    private Lazy<CompositeSpec> pngFormatSpec = this.resolveLazy("PNG_FORMAT", CompositeSpec.class);
    private Lazy<CompositeSpec> pngHeaderSpec = this.resolveLazy("PNG_FILE_SIGNATURE", CompositeSpec.class);
    private Lazy<DWordSpec> pngChunkType = this.resolveLazy("CHUNK_TYPE", DWordSpec.class);

    PngFormatSpecDefinition() {
    }

    @Override
    protected URL getFormatSpecResource() {
        return Objects.requireNonNull(this.getClass().getResource("PNG.formatspec"));
    }

    public CompositeSpec formatSpec() {
        return (CompositeSpec)this.pngFormatSpec.get();
    }

    public CompositeSpec headerSpec() {
        return (CompositeSpec)this.pngHeaderSpec.get();
    }

    public FileScannerResultRenderHandler pngRenderer() {
        return RawTransferHandler.IMAGE_PNG_TRANSFER;
    }

    public FileScannerResultExportHandler pngExporter() {
        return RawTransferHandler.IMAGE_PNG_TRANSFER;
    }

    public String genericChunkName() {
        int typeValue = (Integer)((DWordSpec)this.pngChunkType.get()).get();
        StringBuilder typeString = new StringBuilder();
        typeString.append(this.mapChunkTypeChar(typeValue >>> 24 & 0xFF));
        typeString.append(this.mapChunkTypeChar(typeValue >>> 16 & 0xFF));
        typeString.append(this.mapChunkTypeChar(typeValue >>> 8 & 0xFF));
        typeString.append(this.mapChunkTypeChar(typeValue & 0xFF));
        return typeString.toString();
    }

    private char mapChunkTypeChar(int code) {
        return (char)(65 <= code && code <= 90 || 97 <= code && code <= 122 ? (int)code : 63);
    }
}

