/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.udif;

import de.carne.util.Strings;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.Nullable;

final class BlkxDataDecoder {
    private static final int BUFFER_EXTENT_SIZE = 1024;
    private byte[] buffer = new byte[1024];
    private int decoded = 0;
    private @Nullable IOException exception = null;
    private int register = 0;
    private int bits = 0;
    private int padding = 0;

    BlkxDataDecoder() {
    }

    public void reset() {
        this.decoded = 0;
        this.exception = null;
        this.register = 0;
        this.bits = 0;
        this.padding = 0;
    }

    public boolean isEmpty() {
        return this.decoded == 0;
    }

    public ByteBuffer getResult() throws IOException {
        this.flush();
        if (this.exception != null) {
            throw this.exception;
        }
        return ByteBuffer.wrap(this.buffer, 0, this.decoded);
    }

    public void feed(char[] ch, int start, int length) {
        int end = start + length;
        for (int chIndex = start; chIndex < end; ++chIndex) {
            this.feed0(ch[chIndex]);
        }
    }

    private void feed0(int c) {
        if (this.exception == null) {
            int value = -1;
            if (65 <= c && c <= 90) {
                value = c - 65;
            } else if (97 <= c && c <= 122) {
                value = 26 + (c - 97);
            } else if (48 <= c && c <= 57) {
                value = 52 + (c - 48);
            } else if (c == 43) {
                value = 62 + (c - 43);
            } else if (c == 47) {
                value = 63 + (c - 47);
            } else if (c == 61) {
                this.padding += 6;
                value = 0;
            } else if (!Character.isWhitespace(c)) {
                this.exception = new IOException("Unexpected character: " + Strings.encode((CharSequence)("'" + (char)c + "'")));
            }
            if (value >= 0) {
                this.register = this.register << 6 | value;
                this.bits += 6;
                if (this.bits == 24) {
                    this.flush();
                }
            }
        }
    }

    private void flush() {
        if (this.padding < this.bits) {
            byte[] b = new byte[]{(byte)(this.register >> 16 & 0xFF), (byte)(this.register >> 8 & 0xFF), (byte)(this.register & 0xFF)};
            int len = b.length - this.padding / 6;
            if (this.buffer.length < this.decoded + len) {
                byte[] buffer2 = new byte[this.buffer.length + 1024];
                System.arraycopy(this.buffer, 0, buffer2, 0, this.buffer.length);
                this.buffer = buffer2;
            }
            System.arraycopy(b, 0, this.buffer, this.decoded, len);
            this.decoded += len;
        }
        this.register = 0;
        this.bits = 0;
        this.padding = 0;
    }
}

