/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.udif;

import de.carne.filescanner.engine.UnexpectedDataException;
import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.DecodeAtSpec;
import de.carne.filescanner.engine.format.EncodedInputSpec;
import de.carne.filescanner.engine.format.EncodedInputSpecConfig;
import de.carne.filescanner.engine.format.StructSpec;
import de.carne.filescanner.engine.input.InputDecoderTable;
import de.carne.filescanner.engine.input.InputDecoders;
import de.carne.filescanner.engine.util.Bzip2InputDecoder;
import de.carne.filescanner.engine.util.DeflateInputDecoder;
import de.carne.filescanner.engine.util.LocalEntityResolver;
import de.carne.filescanner.engine.util.LzmaInputDecoder;
import de.carne.filescanner.provider.udif.BlkxDataDecoder;
import de.carne.filescanner.provider.udif.BlkxDescriptor;
import de.carne.nio.compression.bzip2.Bzip2DecoderProperties;
import de.carne.nio.compression.bzip2.Bzip2Format;
import de.carne.nio.compression.deflate.DeflateDecoderProperties;
import de.carne.nio.compression.deflate.DeflateFormat;
import de.carne.nio.compression.lzma.LzmaDecoderProperties;
import de.carne.nio.compression.lzma.LzmaFormat;
import de.carne.util.logging.Log;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class ResourceForkHandler
extends DefaultHandler {
    private static final Log LOG = new Log();
    private static final DeflateInputDecoder ZLIB_INPUT_DECODER;
    private static final Bzip2InputDecoder BZ2LIB_INPUT_DECODER;
    private static final LzmaInputDecoder LZMALIB_INPUT_DECODER;
    private static final String ELEMENT_KEY0 = "plist/dict/key";
    private static final String ELEMENT_KEY1 = "plist/dict/dict/key";
    private static final String ELEMENT_DICT2 = "plist/dict/dict/array/dict";
    private static final String ELEMENT_KEY2 = "plist/dict/dict/array/dict/key";
    private static final String KEY_RESOURCEFORK = "resource-fork";
    private static final String KEY_BLKX = "blkx";
    private static final String KEY_DATA = "Data";
    private static final String KEY_NAME = "Name";
    private final Deque<String> elementStack = new LinkedList<String>();
    private final @NonNull String[] keyPath = new String[]{"", "", ""};
    private final BlkxDataDecoder blkxDataDecoder = new BlkxDataDecoder();
    private final StringBuilder blkxName = new StringBuilder();
    private final SortedMap<BlkxDescriptor, EncodedInputSpec> blkxSpecs = new TreeMap<BlkxDescriptor, EncodedInputSpec>();

    ResourceForkHandler() {
    }

    public static CompositeSpec parse(InputStream input) throws IOException, ParserConfigurationException, SAXException {
        ResourceForkHandler handler = new ResourceForkHandler();
        XMLReader reader = SAXParserFactory.newDefaultInstance().newSAXParser().getXMLReader();
        reader.setEntityResolver(LocalEntityResolver.getInstance());
        reader.setContentHandler(handler);
        reader.parse(new InputSource(input));
        StructSpec parsedSpec = new StructSpec();
        if (!handler.blkxSpecs.isEmpty()) {
            DecodeAtSpec dataForkAtSpec = null;
            StructSpec dataForkSpec = new StructSpec();
            dataForkSpec.result("Data fork");
            for (Map.Entry<BlkxDescriptor, EncodedInputSpec> entry : handler.blkxSpecs.entrySet()) {
                BlkxDescriptor blkxDescriptor = entry.getKey();
                long blkxPosition = blkxDescriptor.blkxPosition();
                if (dataForkAtSpec == null) {
                    dataForkAtSpec = new DecodeAtSpec(dataForkSpec).position(blkxPosition);
                    parsedSpec.add(dataForkAtSpec);
                }
                DecodeAtSpec entryAtSpec = new DecodeAtSpec(entry.getValue());
                entryAtSpec.position(blkxPosition);
                dataForkSpec.add(entryAtSpec);
            }
        }
        return parsedSpec;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.elementStack.isEmpty()) {
            this.elementStack.push(qName);
        } else {
            this.elementStack.push(this.elementStack.peek() + "/" + qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String element = this.elementStack.peek();
        if (ELEMENT_KEY0.equals(element)) {
            this.keyPath[0] = new String(ch, start, length);
            this.keyPath[1] = "";
            this.keyPath[2] = "";
        } else if (ELEMENT_KEY1.equals(element)) {
            if (KEY_RESOURCEFORK.equals(this.keyPath[0])) {
                this.keyPath[1] = new String(ch, start, length);
                this.keyPath[2] = "";
            }
        } else if (ELEMENT_KEY2.equals(element)) {
            if (KEY_BLKX.equals(this.keyPath[1])) {
                this.keyPath[2] = new String(ch, start, length);
            }
        } else if (KEY_RESOURCEFORK.equals(this.keyPath[0]) && KEY_BLKX.equals(this.keyPath[1])) {
            if (KEY_DATA.equals(this.keyPath[2])) {
                this.blkxDataDecoder.feed(ch, start, length);
            } else if (KEY_NAME.equals(this.keyPath[2])) {
                this.blkxName.append(ch, start, length);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String element = this.elementStack.pop();
        if (ELEMENT_DICT2.equals(element) && KEY_RESOURCEFORK.equals(this.keyPath[0]) && KEY_BLKX.equals(this.keyPath[1])) {
            if (!this.blkxDataDecoder.isEmpty() && this.blkxName.length() > 0) {
                String trimmedBlkxName = this.blkxName.toString().trim();
                try {
                    ByteBuffer blkxData = this.blkxDataDecoder.getResult().order(ByteOrder.BIG_ENDIAN);
                    InputDecoderTable blkxDecoderTable = new InputDecoderTable();
                    BlkxDescriptor blkxDescriptor = this.decodeBlkxChunks(blkxDecoderTable, blkxData, this.decodeBlkxHeader(blkxData));
                    if (blkxDescriptor.dataChunkCount() > 0) {
                        EncodedInputSpecConfig blkxSpecConfig = new EncodedInputSpecConfig(trimmedBlkxName).inputDecoderTable(blkxDecoderTable);
                        EncodedInputSpec blkxSpec = new EncodedInputSpec(blkxSpecConfig);
                        this.blkxSpecs.put(blkxDescriptor, blkxSpec);
                    }
                }
                catch (IOException e) {
                    LOG.warning((Throwable)e, "Failed to decode block list ''{0}''", new Object[]{trimmedBlkxName});
                }
            }
            this.blkxDataDecoder.reset();
            this.blkxName.setLength(0);
        }
    }

    private BlkxDescriptor decodeBlkxHeader(ByteBuffer blkxData) throws IOException {
        if (blkxData.remaining() < 204) {
            throw this.unexpectedData("Insufficient block list size", blkxData.remaining());
        }
        int signature = blkxData.getInt();
        int version = blkxData.getInt();
        long sectorNumber = blkxData.getLong();
        long sectorCount = blkxData.getLong();
        long dataOffset = blkxData.getLong();
        if (signature != 1835627368 || version != 1 || dataOffset < 0L) {
            throw this.unexpectedData("Unexpected block list header data", signature, version, dataOffset);
        }
        blkxData.position(blkxData.position() + 168);
        return new BlkxDescriptor(dataOffset, 0, sectorNumber, sectorNumber + sectorCount);
    }

    private BlkxDescriptor decodeBlkxChunks(InputDecoderTable inputDecoderTable, ByteBuffer blkxData, BlkxDescriptor blkxDescriptor) throws IOException {
        int chunkCount = blkxData.getInt();
        if (blkxData.remaining() < chunkCount * 40) {
            throw this.unexpectedData("Insufficient block list entry size", blkxData.remaining());
        }
        long blkxPosition = blkxDescriptor.blkxPosition();
        int dataChunkCount = 0;
        block10: for (int chunkIndex = 0; chunkIndex < chunkCount; ++chunkIndex) {
            int entryType = blkxData.getInt();
            blkxData.getInt();
            blkxData.getLong();
            long chunkSectorCount = blkxData.getLong();
            long compressedOffset = blkxData.getLong();
            long compressedSize = blkxData.getLong();
            if (chunkIndex == 0) {
                blkxPosition += compressedOffset;
            }
            compressedOffset -= blkxPosition;
            switch (entryType) {
                case 0: 
                case 2: {
                    inputDecoderTable.add(InputDecoders.ZERO, -1L, -1L, chunkSectorCount * 512L);
                    continue block10;
                }
                case 1: {
                    inputDecoderTable.add(InputDecoders.IDENTITY, compressedOffset, compressedSize, -1L);
                    ++dataChunkCount;
                    continue block10;
                }
                case -2147483644: {
                    inputDecoderTable.add(InputDecoders.unsupportedInputDecoder("Apple Data Compression (ADC)"), compressedOffset, compressedSize, -1L);
                    ++dataChunkCount;
                    continue block10;
                }
                case -2147483643: {
                    inputDecoderTable.add(ZLIB_INPUT_DECODER, compressedOffset, compressedSize, -1L);
                    ++dataChunkCount;
                    continue block10;
                }
                case -2147483642: {
                    inputDecoderTable.add(BZ2LIB_INPUT_DECODER, compressedOffset, compressedSize, -1L);
                    ++dataChunkCount;
                    continue block10;
                }
                case -2147483641: {
                    inputDecoderTable.add(LZMALIB_INPUT_DECODER, compressedOffset, compressedSize, -1L);
                    ++dataChunkCount;
                    continue block10;
                }
                case 0x7FFFFFFE: {
                    continue block10;
                }
                case -1: {
                    continue block10;
                }
                default: {
                    throw this.unexpectedData("Unexpected entry type", entryType);
                }
            }
        }
        return new BlkxDescriptor(blkxPosition, dataChunkCount, blkxDescriptor.sectorStart(), blkxDescriptor.sectorEnd());
    }

    private UnexpectedDataException unexpectedData(String hint, Object ... data) {
        return new UnexpectedDataException(hint, -1L, data);
    }

    static {
        DeflateDecoderProperties properties = DeflateInputDecoder.defaultProperties();
        properties.setFormatProperty(DeflateFormat.ZLIB);
        ZLIB_INPUT_DECODER = new DeflateInputDecoder(properties);
        properties = Bzip2InputDecoder.defaultProperties();
        properties.setFormat(Bzip2Format.BZ2LIB);
        BZ2LIB_INPUT_DECODER = new Bzip2InputDecoder((Bzip2DecoderProperties)properties);
        properties = LzmaInputDecoder.defaultProperties();
        properties.setFormat(LzmaFormat.LZMALIB);
        LZMALIB_INPUT_DECODER = new LzmaInputDecoder((LzmaDecoderProperties)properties);
    }
}

