/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.udif;

import de.carne.filescanner.engine.FileScannerResultContextValueSpecs;
import de.carne.filescanner.engine.StreamValue;
import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.FormatSpecDefinition;
import de.carne.filescanner.engine.format.FormatSpecs;
import de.carne.filescanner.engine.format.RangeAttributeSpec;
import de.carne.filescanner.engine.transfer.FileScannerResultRenderHandler;
import de.carne.filescanner.engine.transfer.handler.StyledTextRenderHandler;
import de.carne.filescanner.provider.udif.ResourceForkHandler;
import de.carne.util.Lazy;
import de.carne.util.logging.Log;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;

final class UdifFormatSpecDefinition
extends FormatSpecDefinition {
    private static final Log LOG = new Log();
    private static final StyledTextRenderHandler RESOURCE_FORK_RENDERER = StyledTextRenderHandler.XML_UTF8_RENDER_HANDLER;
    private Lazy<CompositeSpec> udifFormatSpec = this.resolveLazy("UDIF_FORMAT", CompositeSpec.class);
    private Lazy<CompositeSpec> udifTrailerSpec = this.resolveLazy("UDIF_TRAILER", CompositeSpec.class);
    private Lazy<RangeAttributeSpec> resourceForkSpec = this.resolveLazy("XML_PLIST", RangeAttributeSpec.class);

    UdifFormatSpecDefinition() {
    }

    @Override
    protected URL getFormatSpecResource() {
        return Objects.requireNonNull(this.getClass().getResource("UDIF.formatspec"));
    }

    public CompositeSpec formatSpec() {
        return (CompositeSpec)this.udifFormatSpec.get();
    }

    public CompositeSpec trailerSpec() {
        return (CompositeSpec)this.udifTrailerSpec.get();
    }

    public FileScannerResultRenderHandler resourceForkRenderer() {
        return RESOURCE_FORK_RENDERER;
    }

    public Long imageDataSize() {
        return (Long)FileScannerResultContextValueSpecs.INPUT_SIZE.get() - (long)((CompositeSpec)this.udifTrailerSpec.get()).matchSize();
    }

    public CompositeSpec dataForkSpec() {
        CompositeSpec dataForkSpec = FormatSpecs.EMPTY;
        StreamValue resourceFork = (StreamValue)((RangeAttributeSpec)this.resourceForkSpec.get()).get();
        try (InputStream resourceForkInput = resourceFork.stream();){
            dataForkSpec = ResourceForkHandler.parse(resourceForkInput);
        }
        catch (Exception e) {
            LOG.warning((Throwable)e, "Failed to decode UDIF resource fork XML", new Object[0]);
        }
        return dataForkSpec;
    }
}

