/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.provider.xar;

import de.carne.filescanner.engine.StreamValue;
import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.FormatSpecDefinition;
import de.carne.filescanner.engine.format.FormatSpecs;
import de.carne.filescanner.engine.format.QWordSpec;
import de.carne.filescanner.engine.format.RangeAttributeSpec;
import de.carne.filescanner.engine.format.WordSpec;
import de.carne.filescanner.engine.util.LongHelper;
import de.carne.filescanner.engine.util.ShortHelper;
import de.carne.filescanner.provider.xar.TocHandler;
import de.carne.util.Lazy;
import de.carne.util.logging.Log;
import java.net.URL;
import java.util.Objects;
import java.util.zip.InflaterInputStream;

final class XarFormatSpecDefinition
extends FormatSpecDefinition {
    private static final Log LOG = new Log();
    private Lazy<CompositeSpec> xarFormatSpec = this.resolveLazy("XAR_ARCHIVE", CompositeSpec.class);
    private Lazy<CompositeSpec> xarHeaderSpec = this.resolveLazy("XAR_HEADER", CompositeSpec.class);
    private Lazy<WordSpec> headerSize = this.resolveLazy("HEADER_SIZE", WordSpec.class);
    private Lazy<QWordSpec> tocLength = this.resolveLazy("TOC_LENGTH", QWordSpec.class);
    private Lazy<RangeAttributeSpec> tocXml = this.resolveLazy("TOC_XML", RangeAttributeSpec.class);

    XarFormatSpecDefinition() {
    }

    @Override
    protected URL getFormatSpecResource() {
        return Objects.requireNonNull(this.getClass().getResource("Xar.formatspec"));
    }

    public CompositeSpec formatSpec() {
        return (CompositeSpec)this.xarFormatSpec.get();
    }

    public CompositeSpec headerSpec() {
        return (CompositeSpec)this.xarHeaderSpec.get();
    }

    public Integer tocCksumNameSize() {
        int headerSizeValue = ShortHelper.toUnsignedInt((Number)((WordSpec)this.headerSize.get()).get());
        return Math.max(headerSizeValue - 28, 0);
    }

    public CompositeSpec heapSpec() {
        CompositeSpec heapSpec = FormatSpecs.EMPTY;
        StreamValue tocXmlValue = (StreamValue)((RangeAttributeSpec)this.tocXml.get()).get();
        long heapOffset = LongHelper.toUnsignedLong((Number)((WordSpec)this.headerSize.get()).get()) + LongHelper.toUnsignedLong((Number)((QWordSpec)this.tocLength.get()).get());
        try (InflaterInputStream tocXmlInput = new InflaterInputStream(tocXmlValue.stream());){
            heapSpec = TocHandler.parse(tocXmlInput, heapOffset);
        }
        catch (Exception e) {
            LOG.warning((Throwable)e, "Failed to decode XAR TOC XML", new Object[0]);
        }
        return heapSpec;
    }
}

