/*
 * Decompiled with CFR 0.152.
 */
package de.carne.test.swt.extension;

import de.carne.util.Check;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Display;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class SWTDisplayParameterResolver
implements ParameterResolver,
AfterAllCallback {
    private static final ExtensionContext.Namespace EXTENSION_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{SWTDisplayParameterResolver.class});
    private static final String DISPLAY_KEY = "Display";

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return parameterContext.getParameter().getType().equals(Display.class);
    }

    public @Nullable Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Optional optionalParentExtensionContext = extensionContext.getParent();
        if (!optionalParentExtensionContext.isPresent()) {
            throw new ParameterResolutionException("Parent extension context missing");
        }
        ExtensionContext.Store store = ((ExtensionContext)optionalParentExtensionContext.get()).getStore(EXTENSION_NAMESPACE);
        Object displayObject = store.get((Object)DISPLAY_KEY);
        if (displayObject == null) {
            displayObject = new Display();
            store.put((Object)DISPLAY_KEY, displayObject);
        }
        return Check.isInstanceOf((Object)displayObject, Display.class);
    }

    public void afterAll(ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(EXTENSION_NAMESPACE);
        Object displayObject = store.get((Object)DISPLAY_KEY);
        if (displayObject != null) {
            ((Display)Check.isInstanceOf((Object)displayObject, Display.class)).dispose();
        }
    }
}

