/*
 * Decompiled with CFR 0.152.
 */
package de.carne.test.swt.platform;

import de.carne.util.Exceptions;
import de.carne.util.Lazy;
import java.io.IOException;
import java.nio.file.Path;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public abstract class PlatformHelper {
    private static final Lazy<PlatformHelper> INSTANCE_HOLDER = new Lazy(PlatformHelper::getInstance);

    private static PlatformHelper getInstance() {
        PlatformHelper instance;
        try {
            String platform = SWT.getPlatform();
            String platformName = PlatformHelper.class.getPackage().getName() + "." + platform + "." + platform.substring(0, 1).toUpperCase() + platform.substring(1) + PlatformHelper.class.getSimpleName();
            instance = Class.forName(platformName).asSubclass(PlatformHelper.class).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw Exceptions.toRuntime((Throwable)e);
        }
        return instance;
    }

    protected PlatformHelper() {
    }

    public static boolean isCurrentThreadSWTCapable() {
        return ((PlatformHelper)INSTANCE_HOLDER.get()).internalIsCurrentThreadSWTCapable();
    }

    protected boolean internalIsCurrentThreadSWTCapable() {
        return false;
    }

    public static boolean inNativeDialog(Display display) {
        return ((PlatformHelper)INSTANCE_HOLDER.get()).internalInNativeDialog(display);
    }

    protected boolean internalInNativeDialog(Display display) {
        return false;
    }

    public static boolean closeNativeDialogs(Display display) {
        return ((PlatformHelper)INSTANCE_HOLDER.get()).internalCloseNativeDialogs(display);
    }

    protected boolean internalCloseNativeDialogs(Display display) {
        return false;
    }

    public static Path grabScreen(Path dir) throws IOException {
        return ((PlatformHelper)INSTANCE_HOLDER.get()).internalGrabScreen(dir);
    }

    protected Path internalGrabScreen(Path dir) throws IOException {
        throw new IOException("No screenshot command found");
    }
}

