/*
 * Decompiled with CFR 0.152.
 */
package de.carne.test.swt.platform;

import de.carne.util.Exceptions;
import de.carne.util.Strings;
import de.carne.util.logging.Log;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public final class ProcessRunner {
    private static final Log LOG = new Log();
    private ProcessBuilder builder;
    private long timeoutMillis = 1000L;
    private boolean captureOutput = false;
    private Status status = Status.NOT_YET_RUN;
    private Optional<IOException> statusException = Optional.empty();
    private int exitValue = -1;
    private String output = "";

    public ProcessRunner(String ... command) {
        this.builder = new ProcessBuilder(command).redirectErrorStream(true);
    }

    public ProcessRunner withTimeout(long timeout) {
        this.timeoutMillis = timeout;
        return this;
    }

    public ProcessRunner withCaptureOutput(boolean capture) {
        this.captureOutput = capture;
        return this;
    }

    public Status run() {
        LOG.debug("Running ''{0}''...", new Object[]{this});
        this.statusException = Optional.empty();
        this.exitValue = -1;
        this.output = "";
        Process process = null;
        try {
            process = this.builder.start();
        }
        catch (IOException e) {
            LOG.warning((Throwable)e, "Process start failed", new Object[0]);
            this.status = Status.START_FAILED;
            this.statusException = Optional.of(e);
        }
        if (process != null) {
            try {
                if (this.captureOutput) {
                    this.output = new String(process.getInputStream().readAllBytes());
                }
                if (process.waitFor(this.timeoutMillis, TimeUnit.MILLISECONDS)) {
                    this.exitValue = process.exitValue();
                    this.status = Status.RUN_COMPLETED;
                } else {
                    LOG.warning("Process timed out", new Object[0]);
                    this.status = Status.RUN_TIMED_OUT;
                    process.destroyForcibly();
                }
            }
            catch (IOException e) {
                LOG.warning((Throwable)e, "Process run failed", new Object[0]);
                this.status = Status.RUN_FAILED;
                this.statusException = Optional.of(e);
            }
            catch (InterruptedException e) {
                LOG.warning((Throwable)e, "Process run interrupted", new Object[0]);
                Thread.currentThread().interrupt();
                this.status = Status.RUN_INTERRUPTED;
                this.statusException = Optional.of(new IOException(Exceptions.getMessage((Throwable)e), e));
            }
        }
        return this.status;
    }

    public void checkStatus() throws IOException {
        if (this.status != Status.RUN_COMPLETED || this.exitValue != 0) {
            if (this.statusException.isPresent()) {
                throw this.statusException.get();
            }
            throw new IOException("Command '" + this + "' failed (status: " + this.status + "; exit value: " + this.exitValue + ")");
        }
    }

    public Optional<IOException> statusException() {
        return this.statusException;
    }

    public int exitValue() {
        return this.exitValue;
    }

    public String output() {
        return this.output;
    }

    public String toString() {
        return Strings.join(this.builder.command(), (String)" ");
    }

    public static enum Status {
        NOT_YET_RUN,
        START_FAILED,
        RUN_FAILED,
        RUN_TIMED_OUT,
        RUN_INTERRUPTED,
        RUN_COMPLETED;

    }
}

