/*
 * Decompiled with CFR 0.152.
 */
package de.carne.test.swt.platform.win32;

import de.carne.test.swt.platform.PlatformHelper;
import de.carne.util.logging.Log;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class Win32PlatformHelper
extends PlatformHelper {
    private static final Log LOG = new Log();

    @Override
    protected boolean internalIsCurrentThreadSWTCapable() {
        return true;
    }

    @Override
    protected boolean internalInNativeDialog(Display display) {
        AtomicBoolean resultHolder = new AtomicBoolean();
        if (!display.isDisposed()) {
            if (Thread.currentThread().equals(display.getThread())) {
                resultHolder.set(this.findNativeDialog(display) != 0L);
            } else {
                display.syncExec(() -> resultHolder.set(this.internalInNativeDialog(display)));
            }
        }
        return resultHolder.get();
    }

    @Override
    protected boolean internalCloseNativeDialogs(Display display) {
        AtomicBoolean resultHolder = new AtomicBoolean();
        if (Thread.currentThread().equals(display.getThread())) {
            long nativeDialog = this.findNativeDialog(display);
            if (nativeDialog != 0L) {
                LOG.debug("Destroying native dialog result: 0x{0}", new Object[]{Long.toHexString(nativeDialog)});
                OS.DestroyWindow((long)nativeDialog);
                resultHolder.set(true);
            }
        } else {
            display.syncExec(() -> resultHolder.set(this.internalCloseNativeDialogs(display)));
        }
        return resultHolder.get();
    }

    private long findNativeDialog(Display display) {
        long activeWindow = OS.GetActiveWindow();
        if (activeWindow != 0L) {
            Shell[] shells;
            for (Shell shell : shells = display.getShells()) {
                if (shell.handle != activeWindow) continue;
                activeWindow = 0L;
                break;
            }
        }
        LOG.debug("Find native dialog result: 0x{0}", new Object[]{Long.toHexString(activeWindow)});
        return activeWindow;
    }
}

