/*
 * Decompiled with CFR 0.152.
 */
package de.carne.test.swt.tester;

import de.carne.test.swt.tester.ColorDialogMock;
import de.carne.test.swt.tester.DialogMock;
import de.carne.test.swt.tester.DirectoryDialogMock;
import de.carne.test.swt.tester.FileDialogMock;
import de.carne.test.swt.tester.FontDialogMock;
import de.carne.test.swt.tester.IntDialogMock;
import de.carne.test.swt.tester.MainFunction;
import de.carne.test.swt.tester.MessageBoxMock;
import de.carne.test.swt.tester.PrintDialogMock;
import de.carne.test.swt.tester.ScriptAction;
import de.carne.test.swt.tester.ScriptRunnerThread;
import de.carne.test.swt.tester.Timing;
import de.carne.test.swt.tester.accessor.Accessor;
import de.carne.test.swt.tester.accessor.DecorationsAccessor;
import de.carne.test.swt.tester.accessor.ShellAccessor;
import de.carne.util.AutoCloseables;
import de.carne.util.Lazy;
import de.carne.util.Strings;
import de.carne.util.logging.Log;
import de.carne.util.stream.Unique;
import java.time.Duration;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;

public abstract class SWTTest {
    private static final Log LOG = new Log();
    private static final Deque<AutoCloseable> RESOURCE_TRACKER = new LinkedList<AutoCloseable>();
    private final String name;
    private final Lazy<MessageBoxMock> messageBoxMock = new Lazy(() -> SWTTest.trackResource(MessageBoxMock::new));
    private final Lazy<FileDialogMock> fileDialogMock = new Lazy(() -> SWTTest.trackResource(FileDialogMock::new));
    private final Lazy<DirectoryDialogMock> directoryDialogMock = new Lazy(() -> SWTTest.trackResource(DirectoryDialogMock::new));
    private final Lazy<PrintDialogMock> printDialogMock = new Lazy(() -> SWTTest.trackResource(PrintDialogMock::new));
    private final Lazy<ColorDialogMock> colorDialogMock = new Lazy(() -> SWTTest.trackResource(ColorDialogMock::new));
    private final Lazy<FontDialogMock> fontDialogMock = new Lazy(() -> SWTTest.trackResource(FontDialogMock::new));

    private static <T extends AutoCloseable> T trackResource(Supplier<T> resourceSupplier) {
        AutoCloseable resource = (AutoCloseable)resourceSupplier.get();
        RESOURCE_TRACKER.add(resource);
        return (T)resource;
    }

    @AfterAll
    static void closeTrackedResources() throws Exception {
        try {
            AutoCloseables.closeAll(RESOURCE_TRACKER);
        }
        finally {
            RESOURCE_TRACKER.clear();
        }
    }

    protected SWTTest() {
        this(SWTTest.defaultName());
    }

    protected SWTTest(String name) {
        this.name = name;
    }

    private static String defaultName() {
        StackTraceElement[] stes = Thread.currentThread().getStackTrace();
        String className = stes[3].getClassName();
        int simpleNameIndex = className.lastIndexOf(46);
        return simpleNameIndex >= 0 ? className.substring(simpleNameIndex + 1) : className;
    }

    public Script script(MainFunction application) {
        return new Script(application);
    }

    void runScript(MainFunction application, String[] applicationArgs, Iterable<ScriptAction> actions, boolean ignoreRemaining, Duration timeout) {
        try {
            ScriptRunnerThread scriptRunnerThread = new ScriptRunnerThread(this.name, actions, ignoreRemaining, timeout);
            scriptRunnerThread.setDaemon(true);
            scriptRunnerThread.start();
            LOG.info("Running application {0} {1}...", new Object[]{application, Strings.join((Object[])applicationArgs, (String)" ")});
            application.main(applicationArgs);
            LOG.info("Application terminated normally", new Object[0]);
            Display display = Display.getCurrent();
            if (display != null) {
                while (!display.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
            Timing wait = new Timing(scriptRunnerThread::join);
            while (scriptRunnerThread.isAlive()) {
                wait.step("Timeout exceeded while waiting for script runner thread to finish");
            }
            scriptRunnerThread.assertionStatus().ifPresent(error -> {
                throw error;
            });
        }
        catch (Exception e) {
            Assertions.fail((String)("Uncaught exception: " + e.getClass().getName()), (Throwable)e);
        }
    }

    protected void traceAction() {
        if (LOG.isInfoLoggable()) {
            StackTraceElement[] stes = Thread.currentThread().getStackTrace();
            LOG.info("Executing {0}", new Object[]{stes[2]});
        }
    }

    protected Display display() {
        return Accessor.get(Display.findDisplay((Thread)Thread.currentThread()));
    }

    protected Stream<Shell> shells() {
        return Arrays.stream(this.display().getShells());
    }

    protected ShellAccessor accessActiveShell() {
        return new ShellAccessor(Optional.ofNullable(this.display().getActiveShell()));
    }

    protected ShellAccessor accessShell() {
        return new ShellAccessor((Optional)this.shells().collect(Unique.getOptional()));
    }

    protected ShellAccessor accessShell(String text) {
        return new ShellAccessor((Optional)this.shells().filter(DecorationsAccessor.matchText(text)).collect(Unique.getOptional()));
    }

    protected ShellAccessor accessShell(Pattern textPattern) {
        return new ShellAccessor((Optional)this.shells().filter(DecorationsAccessor.matchText(textPattern)).collect(Unique.getOptional()));
    }

    protected IntDialogMock mockMessageBox() {
        return (IntDialogMock)this.messageBoxMock.get();
    }

    protected DialogMock<String> mockFileDialog() {
        return (DialogMock)this.fileDialogMock.get();
    }

    protected DialogMock<String> mockDirectoryDialog() {
        return (DialogMock)this.directoryDialogMock.get();
    }

    protected DialogMock<PrinterData> mockPrintDialog() {
        return (DialogMock)this.printDialogMock.get();
    }

    protected DialogMock<RGB> mockColorDialog() {
        return (DialogMock)this.colorDialogMock.get();
    }

    protected DialogMock<FontData> mockFontDialog() {
        return (DialogMock)this.fontDialogMock.get();
    }

    public final class Script {
        private final MainFunction application;
        private String[] applicationArgs = new String[0];
        private final List<ScriptAction> actions = new LinkedList<ScriptAction>();
        private boolean passed = false;

        Script(MainFunction application) {
            this.application = application;
        }

        public Script args(String ... args) {
            this.applicationArgs = args;
            return this;
        }

        public Script add(Runnable doAction) {
            this.add(doAction, false);
            return this;
        }

        public Script add(Runnable doAction, boolean async) {
            String actionName = this.nextActionName();
            this.actions.add(async ? new ScriptAction.AsyncDoScriptAction(actionName, doAction) : new ScriptAction.DoScriptAction(actionName, doAction));
            return this;
        }

        public <T, A extends Accessor<T>> Script add(Supplier<A> supplyAction, Consumer<A> consumeAction) {
            this.add(supplyAction, consumeAction, (long)Timing.STEP_COUNT_LIMIT * Timing.STEP_TIMEOUT);
            return this;
        }

        public <T, A extends Accessor<T>> Script add(Supplier<A> supplyAction, Consumer<A> consumeAction, long timeoutMillis) {
            String actionName = this.nextActionName();
            this.actions.add(new ScriptAction.WaitScriptAction(actionName, supplyAction, consumeAction, timeoutMillis));
            return this;
        }

        private String nextActionName() {
            return "Action #" + (this.actions.size() + 1);
        }

        public void execute() {
            this.execute(false);
        }

        public void execute(boolean ignoreRemaining) {
            this.execute(ignoreRemaining, Duration.ofMillis(Timing.TEST_TIMEOUT));
        }

        public void execute(boolean ignoreRemaining, Duration timeout) {
            SWTTest.this.runScript(this.application, this.applicationArgs, this.actions, ignoreRemaining, timeout);
            this.passed = true;
        }

        public boolean passed() {
            return this.passed;
        }
    }
}

