/*
 * Decompiled with CFR 0.152.
 */
package de.carne.test.swt.tester;

import de.carne.test.swt.tester.ScriptRunner;
import de.carne.test.swt.tester.Timing;
import de.carne.test.swt.tester.accessor.Accessor;
import de.carne.util.logging.Log;
import java.util.function.Consumer;
import java.util.function.Supplier;

abstract class ScriptAction {
    private static final Log LOG = new Log();
    private final String name;

    protected ScriptAction(String name) {
        this.name = name;
    }

    abstract void run(ScriptRunner var1) throws InterruptedException;

    protected Log log() {
        return LOG;
    }

    public String toString() {
        return this.name;
    }

    static class WaitScriptAction<T, A extends Accessor<T>>
    extends ScriptAction {
        private final Supplier<A> supplierAction;
        private final Consumer<A> consumerAction;
        private final int stepCountLimit;

        WaitScriptAction(String name, Supplier<A> supplierAction, Consumer<A> consumerAction, long timoutMillis) {
            super(name);
            this.supplierAction = supplierAction;
            this.consumerAction = consumerAction;
            this.stepCountLimit = Timing.stepCountLimit(timoutMillis);
        }

        @Override
        void run(ScriptRunner scriptRunner) throws InterruptedException {
            Accessor suppliedAccessor;
            long start = System.nanoTime();
            Timing supply = new Timing(this.stepCountLimit);
            while (true) {
                if ((suppliedAccessor = (Accessor)scriptRunner.runWait(this.supplierAction)).getOptional().isPresent()) break;
                supply.step("Timeout exceeded while waiting for accessor");
            }
            Runnable consumeSuppliedAccessor = () -> this.consumerAction.accept(suppliedAccessor);
            scriptRunner.runWait(consumeSuppliedAccessor);
            Timing.step();
            long elapsed = System.nanoTime() - start;
            this.log().debug("{0} executed (took {1} ms)", new Object[]{this, elapsed / 1000000L});
        }
    }

    static class DoScriptAction
    extends ScriptAction {
        private final Runnable doAction;

        DoScriptAction(String name, Runnable doAction) {
            super(name);
            this.doAction = doAction;
        }

        @Override
        void run(ScriptRunner scriptRunner) throws InterruptedException {
            long start = System.nanoTime();
            scriptRunner.runWait(() -> {
                try {
                    this.doAction.run();
                }
                catch (AssertionError assertion) {
                    scriptRunner.recordAssertion(assertion);
                }
            });
            long elapsed = System.nanoTime() - start;
            Timing.step();
            this.log().debug("{0} executed (took {1} ms)", new Object[]{this, elapsed / 1000000L});
        }
    }

    static class AsyncDoScriptAction
    extends ScriptAction {
        private final Runnable doAction;

        AsyncDoScriptAction(String name, Runnable doAction) {
            super(name);
            this.doAction = doAction;
        }

        @Override
        void run(ScriptRunner scriptRunner) throws InterruptedException {
            scriptRunner.runNoWait(() -> {
                try {
                    this.doAction.run();
                }
                catch (AssertionError assertion) {
                    scriptRunner.recordAssertion(assertion);
                }
            });
            Timing.step();
            this.log().debug("{0} triggered", new Object[]{this});
        }
    }
}

