/*
 * Decompiled with CFR 0.152.
 */
package de.carne.test.swt.tester;

import de.carne.nio.file.FileUtil;
import de.carne.nio.file.attribute.FileAttributes;
import de.carne.test.swt.platform.PlatformHelper;
import de.carne.test.swt.tester.ScriptAction;
import de.carne.test.swt.tester.ScriptRunner;
import de.carne.test.swt.tester.Timing;
import de.carne.util.Exceptions;
import de.carne.util.Strings;
import de.carne.util.logging.Log;
import de.carne.util.logging.LogLevel;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.junit.jupiter.api.Assertions;
import org.opentest4j.AssertionFailedError;

final class ScriptRunnerThread
extends Thread {
    private static final Log LOG = new Log();
    private final String testName;
    private final Thread displayThread;
    private final Iterable<ScriptAction> actions;
    private final boolean ignoreRemaining;
    private final Duration timeout;
    private final AtomicReference<@Nullable AssertionError> assertionStatus = new AtomicReference();

    ScriptRunnerThread(String testName, Iterable<ScriptAction> actions, boolean ignoreRemaining, Duration timeout) {
        super(ScriptRunnerThread.class.getSimpleName() + " [" + testName + "]");
        this.testName = testName;
        this.displayThread = Thread.currentThread();
        this.actions = actions;
        this.ignoreRemaining = ignoreRemaining;
        this.timeout = timeout;
    }

    public Optional<AssertionError> assertionStatus() {
        return Optional.ofNullable(this.assertionStatus.get());
    }

    @Override
    public void run() {
        LOG.info("{0} started", new Object[]{Thread.currentThread().getName()});
        try {
            List<String> remainingShellTexts;
            this.waitTrigger(this::displayAvailableTrigger);
            LOG.debug("Display is available on display thread; waiting for initial Shell...", new Object[0]);
            this.waitTrigger(this::initialShellVisibleTrigger);
            LOG.debug("Initial Shell is visible; running actions...", new Object[0]);
            Display display = this.getDisplay();
            try {
                Assertions.assertTimeoutPreemptively((Duration)this.timeout, () -> this.runActions(display));
                LOG.debug("All actions processed; cleaning up...", new Object[0]);
            }
            finally {
                remainingShellTexts = this.disposeRemaining(display);
                display.dispose();
            }
            if (!this.ignoreRemaining && !remainingShellTexts.isEmpty()) {
                Assertions.fail((String)("Remaining Shells detected: " + Strings.join(remainingShellTexts, (String)", ")));
            }
        }
        catch (InterruptedException e) {
            this.assertionStatus.set((AssertionError)new AssertionFailedError("Thread interrupted", (Throwable)e));
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.assertionStatus.set((AssertionError)new AssertionFailedError("Uncaught exception: " + e.getClass().getName(), (Throwable)e));
        }
        catch (AssertionError e) {
            this.assertionStatus.set(e);
        }
    }

    private void runActions(Display display) throws InterruptedException {
        ScriptRunner scriptRunner = this.scriptRunner(display);
        for (ScriptAction action : this.actions) {
            Timing.step();
            action.run(scriptRunner);
        }
    }

    private List<String> disposeRemaining(Display display) throws InterruptedException {
        boolean grabScreen = this.assertionStatus.get() != null || !this.ignoreRemaining;
        boolean screenGrabbed = false;
        ArrayList<String> remainingShellTexts = new ArrayList<String>();
        if (PlatformHelper.inNativeDialog(display)) {
            LOG.log((Level)(this.ignoreRemaining ? LogLevel.LEVEL_INFO : LogLevel.LEVEL_WARNING), null, "Closing native dialog", new Object[0]);
            remainingShellTexts.add("<native dialog>");
            if (grabScreen) {
                this.grabScreen();
                screenGrabbed = true;
            }
            Timing closing = new Timing();
            while (PlatformHelper.closeNativeDialogs(display)) {
                closing.step("Timeout exceeded while waiting for <native dialog>");
            }
        }
        if (!display.isDisposed()) {
            boolean grabScreen0 = grabScreen && !screenGrabbed;
            this.runWait(display, () -> this.disposeRemaining0(remainingShellTexts, display, grabScreen0));
        }
        return remainingShellTexts;
    }

    private List<String> disposeRemaining0(List<String> remainingShellTexts, Display display, boolean grabScreen) {
        if (!display.isDisposed()) {
            Shell[] shells = display.getShells();
            if (grabScreen && shells.length > 0) {
                this.grabScreen();
            }
            for (Shell shell : shells) {
                if (shell.isDisposed()) continue;
                String shellText = shell.getText();
                LOG.log((Level)(this.ignoreRemaining ? LogLevel.LEVEL_INFO : LogLevel.LEVEL_WARNING), null, "Closing remaining Shell ''{0}''", new Object[]{shellText});
                remainingShellTexts.add(shellText);
                shell.close();
                shell.dispose();
            }
            display.dispose();
        }
        return remainingShellTexts;
    }

    private void grabScreen() {
        try {
            Path workingDir = FileUtil.workingDir();
            LOG.info("Grabbing screenshot into directory ''{0}''...", new Object[]{workingDir});
            Path tmpScreenshotFile = PlatformHelper.grabScreen(workingDir);
            LOG.info("Grabbed screenshot to file ''{0}''", new Object[]{tmpScreenshotFile});
            Path screenshotFile = this.createScreenShotFile(tmpScreenshotFile);
            Files.move(tmpScreenshotFile, screenshotFile, StandardCopyOption.REPLACE_EXISTING);
            LOG.info("Grabbed screenshot stored in file ''{0}''", new Object[]{screenshotFile});
        }
        catch (IOException e) {
            LOG.error((Throwable)e, "Failed to grab screenshot", new Object[0]);
        }
    }

    private Path createScreenShotFile(Path tmpScreenshotFile) throws IOException {
        Path dir = tmpScreenshotFile.getParent();
        String extension = FileUtil.splitPath((String)tmpScreenshotFile.getFileName().toString())[2];
        Path screenshotFile = null;
        int screenshotIndex = 0;
        while (screenshotFile == null) {
            if (++screenshotIndex > 9999) {
                throw new IOException("Too many screenshots");
            }
            try {
                Path createdFile = dir.resolve(String.format("%1$s%2$04d.%3$s", this.testName, screenshotIndex, extension));
                screenshotFile = Files.createFile(createdFile, FileAttributes.userFileDefault((Path)dir));
            }
            catch (IOException e) {
                Exceptions.ignore((Throwable)e);
            }
        }
        return screenshotFile;
    }

    private Display getDisplay() {
        Display display = Display.findDisplay((Thread)this.displayThread);
        Assertions.assertNotNull((Object)display, (String)"No Display found");
        return Objects.requireNonNull(display);
    }

    private void waitTrigger(BooleanSupplier trigger) throws InterruptedException {
        Timing.step();
        Timing wait = new Timing();
        while (!trigger.getAsBoolean()) {
            wait.step("Timeout execeeded while waiting for trigger");
        }
    }

    private boolean displayAvailableTrigger() {
        return Display.findDisplay((Thread)this.displayThread) != null;
    }

    private boolean initialShellVisibleTrigger() {
        Display display = Display.findDisplay((Thread)this.displayThread);
        return display != null && !display.isDisposed() && this.runWait(display, () -> {
            Shell[] shells = !display.isDisposed() ? display.getShells() : null;
            return shells != null && shells[0].isVisible();
        }) != false;
    }

    private ScriptRunner scriptRunner(final Display display) {
        return new ScriptRunner(){

            @Override
            public void runNoWait(Runnable runnable) {
                ScriptRunnerThread.this.runNoWait(display, runnable);
            }

            @Override
            public void runWait(Runnable runnable) {
                ScriptRunnerThread.this.runWait(display, runnable);
            }

            @Override
            public <T> T runWait(Supplier<T> supplier) {
                return ScriptRunnerThread.this.runWait(display, supplier);
            }

            @Override
            public void recordAssertion(AssertionError assertion) {
                ScriptRunnerThread.this.recordAssertion(assertion);
            }
        };
    }

    void runNoWait(Display display, Runnable runnable) {
        this.checkDisplayNotDisposed(display);
        display.asyncExec(runnable);
    }

    void runWait(Display display, Runnable runnable) {
        this.checkDisplayNotDisposed(display);
        if (Thread.currentThread().equals(display.getThread())) {
            runnable.run();
        } else {
            this.checkNativeDialog(display);
            display.syncExec(runnable);
            this.checkAssertion();
        }
    }

    <T> T runWait(Display display, Supplier<T> supplier) {
        this.checkDisplayNotDisposed(display);
        AtomicReference resultHolder = new AtomicReference();
        if (Thread.currentThread().equals(display.getThread())) {
            resultHolder.set(supplier.get());
        } else {
            this.checkNativeDialog(display);
            try {
                display.syncExec(() -> resultHolder.set(supplier.get()));
            }
            catch (RuntimeException | SWTError e) {
                Throwable cause = e.getCause();
                if (cause instanceof AssertionError) {
                    throw (AssertionError)((Object)cause);
                }
                throw e;
            }
        }
        return (T)resultHolder.get();
    }

    void recordAssertion(AssertionError assertion) {
        this.assertionStatus.accumulateAndGet(assertion, (current, update) -> {
            AssertionError next = update;
            if (current != null) {
                ((Throwable)((Object)current)).addSuppressed((Throwable)((Object)update));
                next = current;
            }
            return next;
        });
    }

    private void checkAssertion() {
        AssertionError assertion = this.assertionStatus.get();
        if (assertion != null) {
            throw assertion;
        }
    }

    private void checkDisplayNotDisposed(Display display) {
        if (display.isDisposed()) {
            Assertions.fail((String)"Display disposed");
        }
    }

    private void checkNativeDialog(Display display) {
        if (PlatformHelper.inNativeDialog(display)) {
            Assertions.fail((String)"Native dialog detected");
        }
    }
}

