/*
 * Decompiled with CFR 0.152.
 */
package de.carne.test.swt.tester;

import de.carne.test.swt.tester.Synchronizer;
import de.carne.util.SystemProperties;
import org.junit.jupiter.api.Assertions;

final class Timing {
    private static final String PROPERTY_TEST_TIMEOUT = Timing.class.getPackage().getName() + ".TEST_TIMEOUT";
    public static final long TEST_TIMEOUT = SystemProperties.longValue((String)PROPERTY_TEST_TIMEOUT, (long)300000L);
    private static final String PROPERTY_STEP_TIMEOUT = Timing.class.getPackage().getName() + ".STEP_TIMEOUT";
    public static final long STEP_TIMEOUT = SystemProperties.longValue((String)PROPERTY_STEP_TIMEOUT, (long)500L);
    private static final String PROPERTY_STEP_COUNT_LIMIT = Timing.class.getPackage().getName() + ".STEP_COUNT_LIMIT";
    public static final int STEP_COUNT_LIMIT = SystemProperties.intValue((String)PROPERTY_STEP_COUNT_LIMIT, (int)10);
    private int stepCountLimit;
    private final Synchronizer synchronizer;
    private int stepCount;

    public Timing() {
        this(STEP_COUNT_LIMIT, Thread::sleep);
    }

    public Timing(int stepCountLimit) {
        this(stepCountLimit, Thread::sleep);
    }

    public Timing(Synchronizer synchronizer) {
        this(STEP_COUNT_LIMIT, synchronizer);
    }

    public Timing(int stepCountLimit, Synchronizer synchronizer) {
        this.stepCountLimit = stepCountLimit;
        this.synchronizer = synchronizer;
        this.stepCount = 0;
    }

    public void step(String timeoutMessage) throws InterruptedException {
        if (this.stepCount >= this.stepCountLimit) {
            Assertions.fail((String)timeoutMessage);
        }
        this.synchronizer.sync(STEP_TIMEOUT);
        ++this.stepCount;
    }

    public static int stepCountLimit(long timoutMillis) {
        return (int)Math.floorDiv(timoutMillis + STEP_TIMEOUT - 1L, STEP_TIMEOUT);
    }

    public static void step() throws InterruptedException {
        Thread.sleep(STEP_TIMEOUT);
    }
}

