/*
 * Decompiled with CFR 0.152.
 */
package de.carne.test.swt.tester.accessor;

import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.Nullable;
import org.opentest4j.AssertionFailedError;

public class Accessor<T>
implements Supplier<T> {
    private static final Accessor<Object> NOT_PRESENT = new Accessor(Optional.empty());
    private final Optional<T> objectHolder;

    public Accessor(@Nullable T object) {
        this.objectHolder = Optional.ofNullable(object);
    }

    public Accessor(Optional<T> objectHolder) {
        this.objectHolder = objectHolder;
    }

    public Accessor(Accessor<T> accessor) {
        this(accessor.objectHolder);
    }

    @Override
    public T get() {
        return this.objectHolder.orElseThrow(() -> new AssertionFailedError("No such object"));
    }

    public Optional<T> getOptional() {
        return this.objectHolder;
    }

    public static <T> T get(@Nullable T object) {
        return new Accessor<T>(object).get();
    }

    public static <T> Accessor<T> notPresent() {
        return NOT_PRESENT;
    }

    public int hashCode() {
        return this.objectHolder.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return this.objectHolder.equals(obj);
    }

    public String toString() {
        return this.objectHolder.toString();
    }
}

