/*
 * Decompiled with CFR 0.152.
 */
package de.carne.test.swt.tester.accessor;

import de.carne.test.swt.tester.accessor.Accessor;
import de.carne.test.swt.tester.accessor.ButtonAccessor;
import de.carne.test.swt.tester.accessor.ControlAccessor;
import de.carne.test.swt.tester.accessor.WrapFunction;
import de.carne.util.stream.Unique;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CompositeAccessor<T extends Composite>
extends ControlAccessor<T> {
    public CompositeAccessor(@Nullable T composite) {
        super(composite);
    }

    public CompositeAccessor(Optional<T> compositeHolder) {
        super(compositeHolder);
    }

    public CompositeAccessor(Accessor<T> accessor) {
        super(accessor);
    }

    public Stream<Control> children() {
        Optional optionalComposite = this.getOptional();
        return optionalComposite.isPresent() ? this.collectChildren(new ArrayList<Control>(), (Composite)this.get(), 0).stream() : Stream.empty();
    }

    private List<Control> collectChildren(List<Control> children, Composite composite, int level) {
        @NonNull Control[] controls = composite.getChildren();
        children.addAll(Arrays.asList(controls));
        for (Control control : controls) {
            if (!(control instanceof Composite)) continue;
            this.collectChildren(children, (Composite)control, level + 1);
        }
        return children;
    }

    public <C extends Control, A extends Accessor<C>> @NonNull A accessChild(WrapFunction<C, A> wrap, Class<C> childClass, Predicate<C> predicate) {
        return (A)((Accessor)wrap.apply((Optional)this.children().filter(ControlAccessor.matchClass(childClass)).map(childClass::cast).filter(predicate).collect(Unique.getOptional())));
    }

    public <C extends Control, A extends Accessor<?>> A accessChild(WrapFunction<C, A> wrap, Class<C> childClass, int childIndex) {
        Optional optionalComposite = this.getOptional();
        Control child = null;
        if (optionalComposite.isPresent()) {
            Control childControl;
            Control[] children = ((Composite)optionalComposite.get()).getChildren();
            if (0 <= childIndex && childIndex < children.length && childClass.isAssignableFrom((childControl = children[childIndex]).getClass())) {
                child = (Control)childClass.cast(childControl);
            }
        }
        return (A)((Accessor)wrap.apply(Optional.ofNullable(child)));
    }

    public ButtonAccessor accessButton(Predicate<Button> predicate) {
        return (ButtonAccessor)this.accessChild(ButtonAccessor::new, Button.class, predicate);
    }

    public ButtonAccessor accessButton(String text) {
        return (ButtonAccessor)this.accessChild(ButtonAccessor::new, Button.class, ButtonAccessor.matchText(text));
    }

    public ButtonAccessor accessButton(int childIndex) {
        return (ButtonAccessor)this.accessChild(ButtonAccessor::new, Button.class, childIndex);
    }
}

