/*
 * Decompiled with CFR 0.152.
 */
package de.carne.test.swt.tester.accessor;

import de.carne.test.swt.tester.accessor.Accessor;
import de.carne.test.swt.tester.accessor.ItemAccessor;
import de.carne.test.swt.tester.accessor.MenuItemAccessor;
import de.carne.util.stream.Unique;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MenuAccessor
extends Accessor<Menu> {
    public MenuAccessor(@Nullable Menu menu) {
        super(menu);
    }

    public MenuAccessor(Optional<Menu> optionalMenu) {
        super(optionalMenu);
    }

    public MenuAccessor(Accessor<Menu> accessor) {
        super(accessor);
    }

    public Stream<MenuItem> items() {
        Optional optionalMenu = this.getOptional();
        return optionalMenu.isPresent() ? this.collectItems(new ArrayList<MenuItem>(), (Menu)optionalMenu.get(), 0).stream() : Stream.empty();
    }

    private List<MenuItem> collectItems(List<MenuItem> items, Menu menu, int level) {
        @NonNull MenuItem[] menuItems = menu.getItems();
        items.addAll(Arrays.asList(menuItems));
        for (MenuItem menuItem : menuItems) {
            Menu itemMenu = menuItem.getMenu();
            if (itemMenu == null) continue;
            this.collectItems(items, itemMenu, level + 1);
        }
        return items;
    }

    public MenuItemAccessor accessItem(Predicate<MenuItem> predicate) {
        return new MenuItemAccessor((Optional)this.items().filter(predicate).collect(Unique.getOptional()));
    }

    public MenuItemAccessor accessItem(String text) {
        return this.accessItem(ItemAccessor.matchText(text));
    }
}

