/*
 * Decompiled with CFR 0.152.
 */
package de.carne.test.swt.tester.accessor;

import de.carne.test.swt.tester.accessor.Accessor;
import de.carne.test.swt.tester.accessor.ControlAccessor;
import de.carne.test.swt.tester.accessor.ItemAccessor;
import de.carne.test.swt.tester.accessor.ToolItemAccessor;
import de.carne.util.stream.Unique;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ToolBarAccessor
extends ControlAccessor<ToolBar> {
    public ToolBarAccessor(@Nullable ToolBar toolBar) {
        super(toolBar);
    }

    public ToolBarAccessor(Optional<ToolBar> toolBarHolder) {
        super(toolBarHolder);
    }

    public ToolBarAccessor(Accessor<ToolBar> accessor) {
        super(accessor);
    }

    public Stream<ToolItem> items() {
        Optional optionalToolBar = this.getOptional();
        return optionalToolBar.isPresent() ? Arrays.stream(((ToolBar)optionalToolBar.get()).getItems()) : Stream.empty();
    }

    public ToolItemAccessor accessItem(Predicate<ToolItem> predicate) {
        return new ToolItemAccessor((Optional)this.items().filter(predicate).collect(Unique.getOptional()));
    }

    public ToolItemAccessor accessItem(String text) {
        return this.accessItem(ItemAccessor.matchText(text));
    }

    public ToolItemAccessor accessItem(int itemIndex) {
        Optional optionalToolBar = this.getOptional();
        return new ToolItemAccessor(optionalToolBar.isPresent() ? this.getToolItem((ToolBar)optionalToolBar.get(), itemIndex) : null);
    }

    private @Nullable ToolItem getToolItem(ToolBar toolBar, int itemIndex) {
        return 0 <= itemIndex && itemIndex < toolBar.getItemCount() ? toolBar.getItem(itemIndex) : null;
    }
}

