/*
 * Decompiled with CFR 0.152.
 */
package de.carne.test.extension.io;

import de.carne.nio.file.FileUtil;
import de.carne.nio.file.attribute.FileAttributes;
import de.carne.test.annotation.io.TempDir;
import de.carne.test.annotation.io.TempFile;
import de.carne.util.Exceptions;
import de.carne.util.logging.Log;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.Nullable;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;

public class TempPathExtension
implements BeforeAllCallback,
BeforeEachCallback,
ParameterResolver {
    private static final Log LOG = new Log();
    private static final ExtensionContext.Namespace EXTENSION_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{TempPathExtension.class});
    private static final Set<Class<?>> SUPPORTED_TYPES = new HashSet<Class>(Arrays.asList(Path.class, File.class));

    public void beforeAll(ExtensionContext context) throws Exception {
        this.injectFields(context, null, field -> Modifier.isStatic(field.getModifiers()));
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.injectFields(context, context.getRequiredTestInstance(), field -> !Modifier.isStatic(field.getModifiers()));
    }

    private void injectFields(ExtensionContext context, @Nullable Object testInstance, Predicate<Field> predicate) {
        AnnotationSupport.findAnnotatedFields((Class)context.getRequiredTestClass(), TempDir.class, predicate, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN).forEach(field -> this.injectField(context, testInstance, (Field)field));
        AnnotationSupport.findAnnotatedFields((Class)context.getRequiredTestClass(), TempFile.class, predicate, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN).forEach(field -> this.injectField(context, testInstance, (Field)field));
    }

    private void injectField(ExtensionContext context, @Nullable Object testInstance, @Nullable Field field) {
        LOG.debug("Injecting field: {0}", new Object[]{field});
        Field checkedField = this.checkField(field);
        try {
            if (checkedField.getAnnotation(TempDir.class) != null) {
                checkedField.set(testInstance, this.getTempDirField(context, checkedField));
            } else {
                checkedField.set(testInstance, this.getTempFileField(context, checkedField));
            }
        }
        catch (IllegalAccessException e) {
            throw Exceptions.toRuntime((Throwable)e);
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        boolean supported;
        boolean bl = supported = parameterContext.isAnnotated(TempDir.class) || parameterContext.isAnnotated(TempFile.class);
        if (supported && parameterContext.getDeclaringExecutable() instanceof Constructor) {
            throw new ParameterResolutionException("Cannot inject Constructor parameters");
        }
        return supported;
    }

    public @Nullable Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Parameter parameter = parameterContext.getParameter();
        LOG.debug("Resolving parameter: {0}", new Object[]{parameter});
        Parameter checkedParameter = this.checkParameter(parameterContext.getParameter());
        return checkedParameter.getAnnotation(TempDir.class) != null ? this.getTempDirParameter(extensionContext, checkedParameter) : this.getTempFileParameter(extensionContext, checkedParameter);
    }

    private Field checkField(@Nullable Field field) {
        Objects.requireNonNull(field);
        Class<?> fieldType = field.getType();
        if (!SUPPORTED_TYPES.contains(fieldType)) {
            throw new ExtensionConfigurationException("Unsupported field type: " + fieldType);
        }
        if (Modifier.isPrivate(field.getModifiers())) {
            throw new ExtensionConfigurationException("Cannot inject private field: " + field);
        }
        field.setAccessible(true);
        return field;
    }

    private Parameter checkParameter(Parameter parameter) {
        Class<?> parameterType = parameter.getType();
        if (!SUPPORTED_TYPES.contains(parameterType)) {
            throw new ExtensionConfigurationException("Unsupported parameter type: " + parameterType);
        }
        return parameter;
    }

    private Object getTempDirField(ExtensionContext context, Field field) {
        Path tempDir = ((TempDirResource)context.getStore(EXTENSION_NAMESPACE).getOrComputeIfAbsent((Object)field, key -> TempPathExtension.createTempDirResource(((Class)context.getTestClass().get()).getSimpleName()), TempDirResource.class)).getPath();
        LOG.debug("Set temporary directory: {0} = {1}", new Object[]{field, tempDir});
        return field.getType().equals(Path.class) ? tempDir : tempDir.toFile();
    }

    private Object getTempDirParameter(ExtensionContext context, Parameter parameter) {
        Path tempDir = ((TempDirResource)context.getStore(EXTENSION_NAMESPACE).getOrComputeIfAbsent((Object)parameter, key -> TempPathExtension.createTempDirResource(((Class)context.getTestClass().get()).getSimpleName()), TempDirResource.class)).getPath();
        LOG.debug("Resolved temporary directory: {0} = {1}", new Object[]{parameter, tempDir});
        return parameter.getType().equals(Path.class) ? tempDir : tempDir.toFile();
    }

    private static TempDirResource createTempDirResource(String prefix) {
        Path tempDir;
        try {
            tempDir = Files.createTempDirectory(prefix, FileAttributes.userDirectoryDefault((Path)FileUtil.tmpDir()));
        }
        catch (IOException e) {
            throw new ExtensionConfigurationException("Failed to create temporary directory", (Throwable)e);
        }
        return new TempDirResource(LOG, tempDir);
    }

    private Object getTempFileField(ExtensionContext context, Field field) {
        Path tempDir = ((TempDirResource)context.getStore(EXTENSION_NAMESPACE).getOrComputeIfAbsent((Object)context.getRequiredTestClass().getSimpleName(), TempPathExtension::createTempDirResource, TempDirResource.class)).getPath();
        Path tempFile = ((TempFileResource)context.getStore(EXTENSION_NAMESPACE).getOrComputeIfAbsent((Object)field, key -> TempPathExtension.createTempFileResource(tempDir, ((Class)context.getTestClass().get()).getSimpleName(), Objects.requireNonNull(field.getAnnotation(TempFile.class)).content()), TempFileResource.class)).getPath();
        LOG.debug("Set temporary file: {0} = {1}", new Object[]{field, tempDir});
        return field.getType().equals(Path.class) ? tempFile : tempFile.toFile();
    }

    private Object getTempFileParameter(ExtensionContext context, Parameter parameter) {
        Path tempDir = ((TempDirResource)context.getStore(EXTENSION_NAMESPACE).getOrComputeIfAbsent((Object)context.getRequiredTestClass().getSimpleName(), TempPathExtension::createTempDirResource, TempDirResource.class)).getPath();
        Path tempFile = ((TempFileResource)context.getStore(EXTENSION_NAMESPACE).getOrComputeIfAbsent((Object)parameter, key -> TempPathExtension.createTempFileResource(tempDir, ((Class)context.getTestClass().get()).getSimpleName(), Objects.requireNonNull(parameter.getAnnotation(TempFile.class)).content()), TempFileResource.class)).getPath();
        LOG.debug("Resolved temporary: file {0} = {1}", new Object[]{parameter, tempDir});
        return parameter.getType().equals(Path.class) ? tempFile : tempFile.toFile();
    }

    private static TempFileResource createTempFileResource(Path tempDir, String prefix, byte[] content) {
        Path tempFile;
        try {
            tempFile = Files.createTempFile(tempDir, prefix, "", new FileAttribute[0]);
            Files.write(tempFile, content, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new ExtensionConfigurationException("Failed to create temporary file", (Throwable)e);
        }
        return new TempFileResource(LOG, tempFile);
    }

    private static class TempFileResource
    implements ExtensionContext.Store.CloseableResource {
        private final Log log;
        private final Path tempFile;

        public TempFileResource(Log log, Path tempFile) {
            this.log = log;
            this.tempFile = tempFile;
        }

        public void close() throws IOException {
            this.log.debug("Deleting temporary file ''{0}''...", new Object[]{this.tempFile});
            FileUtil.delete((Path)this.tempFile);
        }

        public Path getPath() {
            return this.tempFile;
        }
    }

    private static class TempDirResource
    implements ExtensionContext.Store.CloseableResource {
        private final Log log;
        private final Path tempDir;

        public TempDirResource(Log log, Path tempDir) {
            this.log = log;
            this.tempDir = tempDir;
        }

        public void close() throws IOException {
            this.log.debug("Deleting temporary directory: ''{0}''...", new Object[]{this.tempDir});
            FileUtil.delete((Path)this.tempDir);
        }

        public Path getPath() {
            return this.tempDir;
        }
    }
}

