/*
 * Decompiled with CFR 0.152.
 */
package de.carne.test.helper.diff;

import de.carne.test.helper.diff.DiffResult;
import de.carne.test.helper.diff.Differ;
import de.carne.util.Exceptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class Diff {
    private static final int TEXT_DIFFER_RANGE = 100;

    private Diff() {
    }

    public static DiffResult<Character> characters(String string1, String string2) {
        int charIndex;
        int string1Length = string1.length();
        int string2Length = string2.length();
        int range = Math.max(string1Length, string2Length);
        Differ<Character> differ = Differ.characterDiffer(range);
        for (charIndex = 0; charIndex < string1Length; ++charIndex) {
            differ.feedLeft(Character.valueOf(string1.charAt(charIndex)));
        }
        for (charIndex = 0; charIndex < string2Length; ++charIndex) {
            differ.feedRight(Character.valueOf(string2.charAt(charIndex)));
        }
        differ.run(true);
        return differ.toResult();
    }

    public static DiffResult<String> lines(File file1, File file2) throws IOException {
        return Diff.lines(file1, file2, StandardCharsets.UTF_8);
    }

    public static DiffResult<String> lines(File file1, File file2, Charset cs) throws IOException {
        DiffResult<String> result;
        try (BufferedReader reader1 = Diff.newReader(file1, cs);
             BufferedReader reader2 = Diff.newReader(file2, cs);){
            result = Diff.lines(reader1, reader2);
        }
        return result;
    }

    private static BufferedReader newReader(File file, Charset cs) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), cs));
    }

    public static DiffResult<String> lines(String string1, String string2) {
        DiffResult<String> result;
        try (BufferedReader reader1 = Diff.newReader(string1);
             BufferedReader reader2 = Diff.newReader(string2);){
            result = Diff.lines(reader1, reader2);
        }
        catch (IOException e) {
            throw Exceptions.toRuntime((Throwable)e);
        }
        return result;
    }

    private static BufferedReader newReader(String string) {
        return new BufferedReader(new StringReader(string));
    }

    public static DiffResult<String> lines(BufferedReader reader1, BufferedReader reader2) throws IOException {
        Differ<String> differ = Differ.lineDiffer(100);
        String reader1Line = reader1.readLine();
        String reader2Line = reader2.readLine();
        while (differ.isRestrained() && (reader1Line != null || reader2Line != null)) {
            String feedLine;
            while (reader1Line != null) {
                feedLine = reader1Line;
                reader1Line = reader1.readLine();
                if (differ.feedLeft(feedLine)) continue;
                break;
            }
            while (reader2Line != null) {
                feedLine = reader2Line;
                reader2Line = reader2.readLine();
                if (differ.feedRight(feedLine)) continue;
                break;
            }
            differ.run(false);
        }
        differ.run(true);
        return differ.toResult();
    }
}

