/*
 * Decompiled with CFR 0.152.
 */
package de.carne.test.helper.diff;

import de.carne.util.Strings;
import org.eclipse.jdt.annotation.NonNull;

public final class DiffEntry<T> {
    private final int position;
    private final Type type;
    private final @NonNull T value;

    DiffEntry(int position, Type type, @NonNull T value) {
        this.position = position;
        this.type = type;
        this.value = value;
    }

    public int position() {
        return this.position;
    }

    public Type type() {
        return this.type;
    }

    public @NonNull T value() {
        return this.value;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('@').append(this.position).append(this.type == Type.DELETE ? ":-" : ":+");
        Strings.encode((StringBuilder)buffer, (CharSequence)this.value.toString());
        return buffer.toString();
    }

    public static enum Type {
        DELETE,
        INSERT;

    }
}

