/*
 * Decompiled with CFR 0.152.
 */
package de.carne.test.helper.diff;

import de.carne.test.helper.diff.DiffEntry;
import de.carne.util.Strings;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

public final class DiffResult<T>
implements Iterable<DiffEntry<T>> {
    private static final DiffResult<Character> CHARACTER_MATCH = new DiffResult(Collections.emptyList(), true);
    private static final DiffResult<String> LINE_MATCH = new DiffResult(Collections.emptyList(), true);
    private final List<DiffEntry<T>> diffs;
    private final boolean restrained;

    DiffResult(List<DiffEntry<T>> diffs, boolean restrained) {
        this.diffs = diffs;
        this.restrained = restrained;
    }

    public static DiffResult<Character> characterMatch() {
        return CHARACTER_MATCH;
    }

    public static DiffResult<String> lineMatch() {
        return LINE_MATCH;
    }

    public boolean isRestrained() {
        return this.restrained;
    }

    @Override
    public Iterator<DiffEntry<T>> iterator() {
        return this.diffs.iterator();
    }

    public int size() {
        return this.diffs.size();
    }

    public DiffEntry<T> entryAt(int index) {
        return this.diffs.get(index);
    }

    public int hashCode() {
        return this.diffs.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return obj instanceof DiffResult && this.diffs.equals(((DiffResult)obj).diffs);
    }

    public String toString() {
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        LinkedList<DiffEntry<T>> previousEntries = new LinkedList<DiffEntry<T>>();
        for (DiffEntry<T> entry : this) {
            DiffEntry previousEntry = (DiffEntry)previousEntries.peekLast();
            if (previousEntry != null && entry.position() - previousEntry.position() > 1) {
                this.toStringHelper(writer, previousEntries);
                previousEntries.clear();
            }
            previousEntries.add(entry);
        }
        if (!previousEntries.isEmpty()) {
            this.toStringHelper(writer, previousEntries);
        }
        if (!this.restrained) {
            writer.println("...");
        }
        writer.flush();
        return buffer.toString();
    }

    private void toStringHelper(PrintWriter writer, Deque<DiffEntry<T>> previousEntries) {
        int deleteCount = 0;
        int insertCount = 0;
        writer.println("@" + previousEntries.peekFirst().position());
        for (DiffEntry<T> previousEntry : previousEntries) {
            if (previousEntry.type() != DiffEntry.Type.DELETE) continue;
            writer.println("< " + Strings.encode((CharSequence)previousEntry.value().toString()));
            ++deleteCount;
        }
        for (DiffEntry<T> previousEntry : previousEntries) {
            if (previousEntry.type() != DiffEntry.Type.INSERT) continue;
            if (insertCount == 0 && deleteCount > 0) {
                writer.println("---");
            }
            writer.println("> " + Strings.encode((CharSequence)previousEntry.value().toString()));
            ++insertCount;
        }
    }
}

