/*
 * Decompiled with CFR 0.152.
 */
package de.carne.test.helper.diff;

import de.carne.test.helper.diff.DiffEntry;
import de.carne.test.helper.diff.DiffResult;
import de.carne.util.Check;
import java.util.LinkedList;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

class Differ<T> {
    private final int range;
    private final @Nullable T[] left;
    private final @Nullable T[] right;
    private int leftLength = 0;
    private int rightLength = 0;
    private boolean restrained = true;
    private int position = 0;
    private int maxMatchPosition = -1;
    private LinkedList<DiffEntry<T>> diffs = new LinkedList();
    private final int[] forwardTrace;
    private final int[] reverseTrace;

    private Differ(int range, @Nullable T[] left, @Nullable T[] right) {
        this.range = range;
        this.left = left;
        this.right = right;
        this.forwardTrace = new int[(this.range << 1) + 2];
        this.reverseTrace = new int[this.forwardTrace.length];
    }

    public static Differ<Character> characterDiffer(int range) {
        return new Differ<Character>(range, new Character[range], new Character[range]);
    }

    public static Differ<String> lineDiffer(int range) {
        return new Differ<String>(range, new String[range], new String[range]);
    }

    public boolean isRestrained() {
        return this.restrained;
    }

    public boolean feedLeft(T entry) {
        Check.isTrue((this.leftLength < this.range ? 1 : 0) != 0);
        this.left[this.leftLength] = entry;
        ++this.leftLength;
        return this.leftLength < this.range;
    }

    public boolean feedLeft(T[] entries) {
        for (T entry : entries) {
            if (!this.feedLeft(entry)) break;
        }
        return this.leftLength < this.range;
    }

    public boolean feedLeft(Iterable<T> entries) {
        for (T entry : entries) {
            if (!this.feedLeft(entry)) break;
        }
        return this.leftLength < this.range;
    }

    public boolean feedRight(T entry) {
        Check.isTrue((this.rightLength < this.range ? 1 : 0) != 0);
        this.right[this.rightLength] = entry;
        ++this.rightLength;
        return this.rightLength < this.range;
    }

    public boolean feedRight(T[] entries) {
        for (T entry : entries) {
            if (!this.feedRight(entry)) break;
        }
        return this.rightLength < this.range;
    }

    public boolean feedRight(Iterable<T> entries) {
        for (T entry : entries) {
            if (!this.feedRight(entry)) break;
        }
        return this.rightLength < this.range;
    }

    public DiffResult<T> toResult() {
        return new DiffResult<T>(this.diffs, this.isRestrained());
    }

    public void run(boolean finish) {
        if (this.restrained) {
            this.run(0, this.leftLength, 0, this.rightLength);
        }
        if (finish || this.maxMatchPosition < 0) {
            this.position += this.leftLength;
            this.leftLength = 0;
            this.rightLength = 0;
            this.restrained = this.maxMatchPosition >= 0;
        } else {
            DiffEntry<T> lastEntry;
            int leftRemaining = 0;
            int rightRemaining = 0;
            while ((lastEntry = this.diffs.peekLast()) != null && lastEntry.position() > this.maxMatchPosition) {
                if (lastEntry.type() == DiffEntry.Type.DELETE) {
                    ++leftRemaining;
                } else {
                    ++rightRemaining;
                }
                this.diffs.removeLast();
            }
            System.arraycopy(this.left, this.leftLength - leftRemaining, this.left, 0, leftRemaining);
            System.arraycopy(this.right, this.rightLength - rightRemaining, this.right, 0, rightRemaining);
            this.position += this.leftLength - leftRemaining;
            this.leftLength = leftRemaining;
            this.rightLength = leftRemaining;
            this.restrained = this.leftLength < this.range && this.rightLength < this.range;
        }
    }

    private void run(int leftStart, int leftEnd, int rightStart, int rightEnd) {
        Snake snake = this.findSnake(leftStart, leftEnd, rightStart, rightEnd);
        if (snake == null || snake.start() == leftEnd && snake.diag() == leftEnd - rightEnd || snake.end() == leftStart && snake.diag() == leftStart - rightStart) {
            int l = leftStart;
            int r = rightStart;
            while (l < leftEnd || r < rightEnd) {
                if (l < leftEnd && r < rightEnd && this.lrEquals(l, r)) {
                    ++r;
                    this.maxMatchPosition = Math.max(this.maxMatchPosition, this.position + ++l);
                    continue;
                }
                if (leftEnd - leftStart > rightEnd - rightStart) {
                    this.delete(l);
                    ++l;
                    continue;
                }
                this.insert(l, r);
                ++r;
            }
        } else {
            this.run(leftStart, snake.start(), rightStart, snake.start() - snake.diag());
            this.run(snake.end(), leftEnd, snake.end() - snake.diag(), rightEnd);
            int matchCount = snake.end() - snake.start();
            if (matchCount > 0) {
                this.maxMatchPosition = Math.max(this.maxMatchPosition, this.position + matchCount);
            }
        }
    }

    private void delete(int l) {
        this.diffs.add(new DiffEntry<T>(this.position + l, DiffEntry.Type.DELETE, Objects.requireNonNull(this.left[l])));
    }

    private void insert(int l, int r) {
        this.diffs.add(new DiffEntry<T>(this.position + l, DiffEntry.Type.INSERT, Objects.requireNonNull(this.right[r])));
    }

    private @Nullable Snake findSnake(int leftStart, int leftEnd, int rightStart, int rightEnd) {
        Snake snake = null;
        int leftRange = leftEnd - leftStart;
        int rightRange = rightEnd - rightStart;
        if (leftRange > 0 && rightRange > 0) {
            int delta = leftRange - rightRange;
            int sum = leftRange + rightRange;
            int offset = (sum % 2 == 0 ? sum : sum + 1) >> 1;
            this.forwardTrace[1 + offset] = leftStart;
            this.reverseTrace[1 + offset] = leftEnd + 1;
            for (int d = 0; d <= offset && snake == null; ++d) {
                int r;
                int l;
                int t;
                int k;
                for (k = -d; k <= d && snake == null; k += 2) {
                    t = k + offset;
                    this.forwardTrace[t] = k == -d || k != d && this.forwardTrace[t - 1] < this.forwardTrace[t + 1] ? this.forwardTrace[t + 1] : this.forwardTrace[t - 1] + 1;
                    l = this.forwardTrace[t];
                    for (r = l - leftStart + rightStart - k; l < leftEnd && r < rightEnd && this.lrEquals(l, r); ++r) {
                        this.forwardTrace[t] = ++l;
                    }
                    if (delta % 2 == 0 || delta - d > k || k > delta + d || this.reverseTrace[t - delta] > this.forwardTrace[t]) continue;
                    snake = this.getSnake(this.reverseTrace[t - delta], k + leftStart - rightStart, leftEnd, rightEnd);
                }
                for (k = delta - d; k <= delta + d && snake == null; k += 2) {
                    t = k + offset - delta;
                    this.reverseTrace[t] = k == delta - d || k != delta + d && this.reverseTrace[t + 1] <= this.reverseTrace[t - 1] ? this.reverseTrace[t + 1] - 1 : this.reverseTrace[t - 1];
                    l = this.reverseTrace[t] - 1;
                    for (r = l - leftStart + rightStart - k; l >= leftStart && r >= rightStart && this.lrEquals(l, r); --r) {
                        this.reverseTrace[t] = l--;
                    }
                    if (delta % 2 != 0 || -d > k || k > d || this.reverseTrace[t] > this.forwardTrace[t + delta]) continue;
                    snake = this.getSnake(this.reverseTrace[t], k + leftStart - rightStart, leftEnd, rightEnd);
                }
            }
        }
        return snake;
    }

    private Snake getSnake(int start, int diag, int leftEnd, int rightEnd) {
        int end;
        for (end = start; end - diag < rightEnd && end < leftEnd && this.lrEquals(end, end - diag); ++end) {
        }
        return new Snake(start, end, diag);
    }

    private boolean lrEquals(int l, int r) {
        return Objects.requireNonNull(this.left[l]).equals(Objects.requireNonNull(this.right[r]));
    }

    private static final class Snake {
        private final int start;
        private final int end;
        private final int diag;

        Snake(int start, int end, int diag) {
            this.start = start;
            this.end = end;
            this.diag = diag;
        }

        public int start() {
            return this.start;
        }

        public int end() {
            return this.end;
        }

        public int diag() {
            return this.diag;
        }

        public String toString() {
            return this.start + "-" + this.end + ":" + this.diag;
        }
    }
}

