/*
 * Decompiled with CFR 0.152.
 */
package de.carne.test.helper.io;

import de.carne.nio.file.attribute.FileAttributes;
import de.carne.test.helper.io.TestFile;
import de.carne.util.logging.Log;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Random;

public class RandomTestFile
extends TestFile {
    private static final Log LOG = new Log();
    private static final int MIN_RANDOM_FILE_SIZE = 1;
    private static final int MAX_RANDOM_FILE_SIZE = 8192;
    private final Random random = new Random();
    private final String fileName;
    private final int fileSize;

    public RandomTestFile(Path dir, String fileName) {
        this(dir, fileName, -1);
    }

    public RandomTestFile(Path dir, String fileName, int fileSize) {
        super(dir);
        this.fileName = fileName;
        this.fileSize = fileSize >= 0 ? fileSize : 1 + this.random.nextInt(8192);
    }

    @Override
    protected Path getFilePath(Path fileDir) throws IOException {
        Path file = fileDir.resolve(this.fileName);
        if (!Files.exists(file, new LinkOption[0])) {
            LOG.info("Generatoring random file ''{0}'' of size ''{1}''...", new Object[]{file, this.fileSize});
            Files.createDirectories(file.getParent(), FileAttributes.userDirectoryDefault((Path)file));
            try (OutputStream fileStream = Files.newOutputStream(file, StandardOpenOption.CREATE_NEW);){
                byte[] randomBytes = new byte[this.fileSize];
                this.random.nextBytes(randomBytes);
                fileStream.write(randomBytes);
            }
        }
        return file;
    }
}

