/*
 * Decompiled with CFR 0.152.
 */
package de.carne.test.helper.io;

import de.carne.io.Checksum;
import de.carne.io.ChecksumInputStream;
import de.carne.io.IOUtil;
import de.carne.io.NullOutputStream;
import de.carne.io.SHA256Checksum;
import de.carne.nio.file.attribute.FileAttributes;
import de.carne.test.helper.io.TestFile;
import de.carne.text.HexBytes;
import de.carne.util.logging.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.Nullable;

public final class RemoteTestFile
extends TestFile {
    private static final Log LOG = new Log();
    private final String remoteUrl;
    private final @Nullable String localFileName;
    private final @Nullable String checksumValue;

    public RemoteTestFile(Path dir, String remoteUrl) {
        this(dir, remoteUrl, null, null);
    }

    public RemoteTestFile(Path dir, String remoteUrl, @Nullable String localFileName) {
        this(dir, remoteUrl, localFileName, null);
    }

    public RemoteTestFile(Path dir, String remoteUrl, @Nullable String localFileName, @Nullable String checksumValue) {
        super(dir);
        this.remoteUrl = remoteUrl;
        this.localFileName = localFileName;
        this.checksumValue = checksumValue;
    }

    @Override
    public Path getFilePath(Path dir) throws IOException {
        URL remoteFile = new URL(this.remoteUrl);
        Path fileName = Paths.get(this.localFileName != null ? this.localFileName : remoteFile.getPath(), new String[0]).getFileName();
        Path localFile = dir.resolve(fileName).toAbsolutePath();
        this.downloadAndVerifyFile(localFile, remoteFile, true);
        return localFile;
    }

    private void downloadAndVerifyFile(Path localFile, URL remoteFile, boolean retry) throws IOException {
        String localFileChecksumValue = !Files.exists(localFile, new LinkOption[0]) ? this.downloadFile(localFile, remoteFile) : this.checksumFile(localFile);
        if (this.checksumValue == null) {
            LOG.notice("File verification skipped for ''{0}'' (checksum:{1})", new Object[]{localFile, localFileChecksumValue});
        } else if (localFileChecksumValue.equals(this.checksumValue)) {
            LOG.notice("File verification passed for ''{0}'' (checksum:{1})", new Object[]{localFile, localFileChecksumValue});
        } else if (retry) {
            LOG.warning("File verification failed for ''{0}'' (checksum:{1})", new Object[]{localFile, localFileChecksumValue});
            LOG.warning("Restarting download...", new Object[0]);
            Files.delete(localFile);
            this.downloadAndVerifyFile(localFile, remoteFile, false);
        } else {
            String message = MessageFormat.format("Checksum mismatch for file ''{0}'' (excepted: {1}; actual: {2})", localFile, this.checksumValue, localFileChecksumValue);
            LOG.error(message, new Object[0]);
            throw new IOException(message);
        }
    }

    private String downloadFile(Path localFile, URL remoteFile) throws IOException {
        LOG.notice("Downloading ''{0}'' to ''{1}''...", new Object[]{remoteFile, localFile});
        Checksum checksum = this.getChecksumInstance();
        Files.createDirectories(localFile.getParent(), FileAttributes.userDirectoryDefault((Path)localFile));
        try (ChecksumInputStream remoteStream = new ChecksumInputStream(remoteFile.openStream(), checksum);
             OutputStream localStream = Files.newOutputStream(localFile, StandardOpenOption.CREATE_NEW);){
            IOUtil.copyStream((OutputStream)localStream, (InputStream)remoteStream);
        }
        return HexBytes.toStringL((byte[])checksum.getValue());
    }

    private String checksumFile(Path localFile) throws IOException {
        LOG.notice("Verifying already downloaded file ''{0}''...", new Object[]{localFile});
        Checksum checksum = this.getChecksumInstance();
        try (ChecksumInputStream localFileStream = new ChecksumInputStream(Files.newInputStream(localFile, StandardOpenOption.READ), checksum);
             NullOutputStream nullStream = new NullOutputStream();){
            IOUtil.copyStream((OutputStream)nullStream, (InputStream)localFileStream);
        }
        return HexBytes.toStringL((byte[])checksum.getValue());
    }

    private Checksum getChecksumInstance() throws IOException {
        SHA256Checksum checksum;
        try {
            checksum = SHA256Checksum.getInstance();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Checksum algorithm not available", e);
        }
        return checksum;
    }
}

