/*
 * Decompiled with CFR 0.152.
 */
package de.carne.test.mock.net.http;

import de.carne.util.Exceptions;
import de.carne.util.logging.Log;
import java.io.IOException;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.eclipse.jdt.annotation.Nullable;

class HttpClientMock
extends HttpClient {
    private static final Log LOG = new Log();

    HttpClientMock() {
    }

    @Override
    public Optional<CookieHandler> cookieHandler() {
        LOG.callee();
        return Optional.ofNullable(CookieHandler.getDefault());
    }

    @Override
    public Optional<Duration> connectTimeout() {
        LOG.callee();
        return Optional.empty();
    }

    @Override
    public HttpClient.Redirect followRedirects() {
        LOG.callee();
        return HttpClient.Redirect.NEVER;
    }

    @Override
    public Optional<ProxySelector> proxy() {
        LOG.callee();
        return Optional.empty();
    }

    @Override
    public SSLContext sslContext() {
        SSLContext sslContext;
        LOG.callee();
        try {
            sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw Exceptions.toRuntime((Throwable)e);
        }
        return sslContext;
    }

    @Override
    public SSLParameters sslParameters() {
        LOG.callee();
        return this.sslContext().getDefaultSSLParameters();
    }

    @Override
    public Optional<Authenticator> authenticator() {
        LOG.callee();
        return Optional.empty();
    }

    @Override
    public HttpClient.Version version() {
        LOG.callee();
        return HttpClient.Version.HTTP_2;
    }

    @Override
    public Optional<Executor> executor() {
        LOG.callee();
        return Optional.empty();
    }

    @Override
    public <T> HttpResponse<T> send(@Nullable HttpRequest request, @Nullable HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException, InterruptedException {
        LOG.callee();
        Objects.requireNonNull(request);
        throw this.unhandledRequest(request);
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(@Nullable HttpRequest request, @Nullable HttpResponse.BodyHandler<T> responseBodyHandler) {
        LOG.callee();
        return this.sendAsync(request, responseBodyHandler, null);
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(@Nullable HttpRequest request, @Nullable HttpResponse.BodyHandler<T> responseBodyHandler, @Nullable HttpResponse.PushPromiseHandler<T> pushPromiseHandler) {
        LOG.callee();
        Objects.requireNonNull(request);
        throw this.unhandledRequest(request);
    }

    private IllegalArgumentException unhandledRequest(HttpRequest request) {
        return new IllegalArgumentException("Unhandled request: " + request.uri().toASCIIString());
    }
}

