/*
 * Decompiled with CFR 0.152.
 */
package de.carne.test.mock.net.http;

import de.carne.test.mock.ScopedMockInstance;
import de.carne.test.mock.net.http.HttpClientMock;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.util.regex.Pattern;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class HttpClientMockInstance
extends ScopedMockInstance<MockedStatic<HttpClient>, HttpClient> {
    public HttpClientMockInstance() {
        super(HttpClientMockInstance::initialize, (HttpClient)Mockito.spy((Object)new HttpClientMock()));
    }

    private static MockedStatic<HttpClient> initialize(HttpClient instance) {
        MockedStatic mock = Mockito.mockStatic(HttpClient.class);
        mock.when(HttpClient::newHttpClient).thenReturn((Object)instance);
        return mock;
    }

    public static HttpRequest requestUriEq(URI uri) {
        return (HttpRequest)ArgumentMatchers.argThat(request -> uri.equals(request.uri()));
    }

    public static HttpRequest requestUriEq(String uri) {
        return (HttpRequest)ArgumentMatchers.argThat(request -> uri.equals(request.uri().toASCIIString()));
    }

    public static HttpRequest requestUriMatches(Pattern pattern) {
        return (HttpRequest)ArgumentMatchers.argThat(request -> pattern.matcher(request.uri().toASCIIString()).matches());
    }
}

