/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.quartz.spring;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="quartz", ignoreUnknownFields=true)
public class QuartzSchedulerProperties {
    public static final String PREFIX = "quartz";
    public static final String DEFAULT_CONFIG_LOCATION = "classpath:/org/quartz/quartz.properties";
    private boolean enabled = true;
    private Metrics metrics = new Metrics();
    private Persistence persistence = new Persistence();
    private SchedulerFactory schedulerFactory = new SchedulerFactory();
    private String propertiesConfigLocation;
    private Map<String, String> properties = new HashMap<String, String>();
    private boolean overrideConfigLocationProperties = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    public Persistence getPersistence() {
        return this.persistence;
    }

    public void setPersistence(Persistence persistence) {
        this.persistence = persistence;
    }

    public SchedulerFactory getSchedulerFactory() {
        return this.schedulerFactory;
    }

    public void setSchedulerFactory(SchedulerFactory schedulerFactory) {
        this.schedulerFactory = schedulerFactory;
    }

    public String getPropertiesConfigLocation() {
        return this.propertiesConfigLocation;
    }

    public void setPropertiesConfigLocation(String propertiesConfigLocation) {
        this.propertiesConfigLocation = propertiesConfigLocation;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean isOverrideConfigLocationProperties() {
        return this.overrideConfigLocationProperties;
    }

    public void setOverrideConfigLocationProperties(boolean overrideConfigLocationProperties) {
        this.overrideConfigLocationProperties = overrideConfigLocationProperties;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("QuartzSchedulerProperties [enabled=").append(this.enabled).append(", metrics=").append(this.metrics).append(", persistence=").append(this.persistence).append(", schedulerFactory=").append(this.schedulerFactory).append(", propertiesConfigLocation=").append(this.propertiesConfigLocation).append(", properties=").append(this.properties).append(", overrideConfigLocationProperties=").append(this.overrideConfigLocationProperties).append("]");
        return builder.toString();
    }

    public static class SchedulerFactory {
        private String schedulerName;
        private boolean autoStartup = true;
        private boolean waitForJobsToCompleteOnShutdown = false;
        private boolean overwriteExistingJobs = false;
        private boolean exposeSchedulerInRepository = false;
        private int phase = Integer.MAX_VALUE;
        private int startupDelay = 0;

        public String getSchedulerName() {
            return this.schedulerName;
        }

        public void setSchedulerName(String schedulerName) {
            this.schedulerName = schedulerName;
        }

        public boolean isAutoStartup() {
            return this.autoStartup;
        }

        public void setAutoStartup(boolean autoStartup) {
            this.autoStartup = autoStartup;
        }

        public boolean isWaitForJobsToCompleteOnShutdown() {
            return this.waitForJobsToCompleteOnShutdown;
        }

        public void setWaitForJobsToCompleteOnShutdown(boolean waitForJobsToCompleteOnShutdown) {
            this.waitForJobsToCompleteOnShutdown = waitForJobsToCompleteOnShutdown;
        }

        public boolean isOverwriteExistingJobs() {
            return this.overwriteExistingJobs;
        }

        public void setOverwriteExistingJobs(boolean overwriteExistingJobs) {
            this.overwriteExistingJobs = overwriteExistingJobs;
        }

        public boolean isExposeSchedulerInRepository() {
            return this.exposeSchedulerInRepository;
        }

        public void setExposeSchedulerInRepository(boolean exposeSchedulerInRepository) {
            this.exposeSchedulerInRepository = exposeSchedulerInRepository;
        }

        public int getPhase() {
            return this.phase;
        }

        public void setPhase(int phase) {
            this.phase = phase;
        }

        public int getStartupDelay() {
            return this.startupDelay;
        }

        public void setStartupDelay(int startupDelay) {
            this.startupDelay = startupDelay;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SchedulerFactory [schedulerName=").append(this.schedulerName).append(", autoStartup=").append(this.autoStartup).append(", waitForJobsToCompleteOnShutdown=").append(this.waitForJobsToCompleteOnShutdown).append(", overwriteExistingJobs=").append(this.overwriteExistingJobs).append(", exposeSchedulerInRepository=").append(this.exposeSchedulerInRepository).append(", phase=").append(this.phase).append(", startupDelay=").append(this.startupDelay).append("]");
            return builder.toString();
        }
    }

    public static class Persistence {
        private boolean persisted = false;
        private boolean usePlatformTxManager = true;
        private String platformTxManagerBeanName;
        private String dataSourceName;

        public boolean isPersisted() {
            return this.persisted;
        }

        public void setPersisted(boolean persisted) {
            this.persisted = persisted;
        }

        public boolean isUsePlatformTxManager() {
            return this.usePlatformTxManager;
        }

        public void setUsePlatformTxManager(boolean usePlatformTxManager) {
            this.usePlatformTxManager = usePlatformTxManager;
        }

        public String getPlatformTxManagerBeanName() {
            return this.platformTxManagerBeanName;
        }

        public void setPlatformTxManagerBeanName(String platformTxManagerBeanName) {
            this.platformTxManagerBeanName = platformTxManagerBeanName;
        }

        public String getDataSourceName() {
            return this.dataSourceName;
        }

        public void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Persistence [persisted=").append(this.persisted).append(", usePlatformTxManager=").append(this.usePlatformTxManager).append(", dataSourceName=").append(this.dataSourceName).append("]");
            return builder.toString();
        }
    }

    public static class Metrics {
        private boolean enabled = false;
        private String listenerName;
        private boolean enableJobGroupCounter = false;
        private boolean enableJobCounter = true;
        private boolean enableTriggerCounter = true;
        private boolean enableExecutionInstructionCounter = false;
        private boolean enableJobGauges = true;
        private boolean enableTriggerGauges = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getListenerName() {
            return this.listenerName;
        }

        public void setListenerName(String listenerName) {
            this.listenerName = listenerName;
        }

        public boolean isEnableJobGroupCounter() {
            return this.enableJobGroupCounter;
        }

        public void setEnableJobGroupCounter(boolean enableJobGroupCounter) {
            this.enableJobGroupCounter = enableJobGroupCounter;
        }

        public boolean isEnableJobCounter() {
            return this.enableJobCounter;
        }

        public void setEnableJobCounter(boolean enableJobCounter) {
            this.enableJobCounter = enableJobCounter;
        }

        public boolean isEnableTriggerCounter() {
            return this.enableTriggerCounter;
        }

        public void setEnableTriggerCounter(boolean enableTriggerCounter) {
            this.enableTriggerCounter = enableTriggerCounter;
        }

        public boolean isEnableExecutionInstructionCounter() {
            return this.enableExecutionInstructionCounter;
        }

        public void setEnableExecutionInstructionCounter(boolean enableExecutionInstructionCounter) {
            this.enableExecutionInstructionCounter = enableExecutionInstructionCounter;
        }

        public boolean isEnableJobGauges() {
            return this.enableJobGauges;
        }

        public void setEnableJobGauges(boolean enableJobGauges) {
            this.enableJobGauges = enableJobGauges;
        }

        public boolean isEnableTriggerGauges() {
            return this.enableTriggerGauges;
        }

        public void setEnableTriggerGauges(boolean enableTriggerGauges) {
            this.enableTriggerGauges = enableTriggerGauges;
        }
    }
}

