/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.quartz.spring.listener;

import de.chandre.quartz.spring.QuartzSchedulerProperties;
import javax.annotation.PostConstruct;
import org.quartz.JobExecutionContext;
import org.quartz.Trigger;
import org.quartz.listeners.TriggerListenerSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.util.StringUtils;

public class TriggerMetricsListener
extends TriggerListenerSupport {
    public static final String SEPARATOR = ".";
    public static final String METRIC_PREFIX = "quartz.";
    public static final String METRIC_INFIX_TYPE_JOB = "job.";
    public static final String METRIC_INFIX_TYPE_TRIGGER = "trigger.";
    public static final String METRIC_SUFFIX_START = ".fired";
    public static final String METRIC_SUFFIX_COMPLETE = ".completed";
    public static final String METRIC_SUFFIX_MISFIRE = ".misfired";
    private QuartzSchedulerProperties.Metrics metricSettings;
    private String name;
    @Autowired(required=false)
    private CounterService counterService;
    @Autowired(required=false)
    private GaugeService gaugeService;

    public TriggerMetricsListener(QuartzSchedulerProperties.Metrics metrics, String name) {
        this.metricSettings = metrics;
        this.name = StringUtils.isEmpty((Object)name) ? ((Object)((Object)this)).getClass().getSimpleName() : name;
    }

    public boolean isActive() {
        return this.metricSettings.isEnabled() && (this.counterService != null || this.gaugeService != null);
    }

    @PostConstruct
    public void init() {
        this.getLog().info(((Object)((Object)this)).getClass().getName() + " is " + (this.isActive() ? "active" : "deactivated"));
    }

    public String getName() {
        return this.name;
    }

    protected void mesure(String suffix, Trigger trigger, JobExecutionContext context, Trigger.CompletedExecutionInstruction triggerInstructionCode) {
        if (null == this.counterService && null == this.gaugeService) {
            return;
        }
        this.getLog().trace("exposing metrics");
        String jobKey = "quartz.job." + trigger.getJobKey().getGroup() + SEPARATOR + trigger.getJobKey().getName() + suffix;
        String triggerKey = "quartz.trigger." + trigger.getKey().getGroup() + SEPARATOR + trigger.getKey().getName() + suffix;
        if (null != this.counterService) {
            if (this.metricSettings.isEnableJobGroupCounter()) {
                this.counterService.increment("quartz.job." + trigger.getJobKey().getGroup() + suffix);
            }
            if (this.metricSettings.isEnableJobCounter()) {
                this.counterService.increment(jobKey);
            }
            if (this.metricSettings.isEnableTriggerCounter()) {
                this.counterService.increment(triggerKey);
            }
            if (this.metricSettings.isEnableExecutionInstructionCounter() && null != triggerInstructionCode) {
                if (this.metricSettings.isEnableTriggerCounter()) {
                    this.counterService.increment(triggerKey + SEPARATOR + triggerInstructionCode.name());
                }
                if (this.metricSettings.isEnableJobCounter()) {
                    this.counterService.increment(jobKey + SEPARATOR + triggerInstructionCode.name());
                }
            }
        }
        if (null != context && null != this.gaugeService && context.getJobRunTime() != -1L) {
            if (this.metricSettings.isEnableTriggerGauges()) {
                this.gaugeService.submit(triggerKey, Long.valueOf(context.getJobRunTime()).doubleValue());
            }
            if (this.metricSettings.isEnableJobGauges()) {
                this.gaugeService.submit(jobKey, Long.valueOf(context.getJobRunTime()).doubleValue());
            }
        }
    }

    public void triggerFired(Trigger trigger, JobExecutionContext context) {
        this.mesure(METRIC_SUFFIX_START, trigger, context, null);
    }

    public void triggerMisfired(Trigger trigger) {
        this.mesure(METRIC_SUFFIX_MISFIRE, trigger, null, null);
    }

    public void triggerComplete(Trigger trigger, JobExecutionContext context, Trigger.CompletedExecutionInstruction triggerInstructionCode) {
        this.mesure(METRIC_SUFFIX_COMPLETE, trigger, context, triggerInstructionCode);
    }
}

