/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.quartz.spring.queue;

import de.chandre.quartz.spring.queue.QueueService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;

public abstract class AbstractQueueService<T>
implements QueueService<T> {
    private long waitForTerminationTime = 10000L;
    private TimeUnit waitForTerminationUnit = TimeUnit.MILLISECONDS;

    protected abstract Collection<String> getGroupKeys();

    @Override
    public Collection<String> getGroups() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("default");
        Collection<String> keys = this.getGroupKeys();
        if (null != keys) {
            list.addAll(this.getGroupKeys());
        }
        return Collections.unmodifiableList(list);
    }

    public long getWaitForTerminationTime() {
        return this.waitForTerminationTime;
    }

    public void setWaitForTerminationTime(long waitForTerminationTime) {
        this.waitForTerminationTime = waitForTerminationTime;
    }

    public TimeUnit getWaitForTerminationUnit() {
        return this.waitForTerminationUnit;
    }

    public void setWaitForTerminationUnit(TimeUnit waitForTerminationUnit) {
        this.waitForTerminationUnit = waitForTerminationUnit;
    }

    protected void shutdownExecutor(ExecutorService executorService, Log LOG) {
        executorService.shutdown();
        try {
            executorService.awaitTermination(this.getWaitForTerminationTime(), this.getWaitForTerminationUnit());
        }
        catch (InterruptedException e) {
            if (null != LOG) {
                LOG.warn((Object)("ExecutorService didn't shut down within " + this.getWaitForTerminationTime() + " " + (Object)((Object)this.getWaitForTerminationUnit())));
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
            executorService.shutdownNow();
        }
    }
}

