/*
 * Decompiled with CFR 0.152.
 */
package de.chandre.quartz.spring.queue;

import de.chandre.quartz.spring.queue.JobExecutionResult;
import de.chandre.quartz.spring.queue.QueuedInstance;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobCallable
implements Callable<JobExecutionResult> {
    private static final Log LOG = LogFactory.getLog(JobCallable.class);
    private QueuedInstance queuedInstance;
    private Set<String> offeredInstances;

    public JobCallable(QueuedInstance queuedInstance, Set<String> offeredInstances) {
        this.queuedInstance = queuedInstance;
        this.offeredInstances = offeredInstances;
    }

    public String getName() {
        return this.queuedInstance.getName();
    }

    @Override
    public JobExecutionResult call() throws Exception {
        LOG.debug((Object)("starting queued quartz instance " + this.queuedInstance.getName()));
        try {
            boolean result;
            if (!this.offeredInstances.remove(this.queuedInstance.getKey())) {
                LOG.warn((Object)("queued quartz instance " + this.queuedInstance.getName() + " hat not been removed from offered jobs."));
            }
            if (!(result = this.queuedInstance.run())) {
                LOG.debug((Object)("queued quartz instance " + this.queuedInstance.getName() + " ended with false"));
            }
            return new JobExecutionResult(result);
        }
        catch (Throwable e) {
            LOG.debug((Object)("queued quartz instance thowed an exception: " + this.queuedInstance.getName()));
            LOG.debug((Object)e.getMessage(), e);
            return new JobExecutionResult(false, e);
        }
    }
}

