/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class Translator {
    private ImmutableMap<String, String> codon1 = null;
    private ImmutableMap<String, String> codon3 = null;
    private ImmutableMap<String, String> iupac = null;
    private ImmutableMap<String, String> shortToLong = null;
    private ImmutableMap<String, String> longToShort = null;
    private static Translator translator = null;

    private Translator() {
        this.initializeMaps();
    }

    public static Translator getTranslator() {
        if (translator == null) {
            translator = new Translator();
        }
        return translator;
    }

    public String translateDNA(String dnaseq) {
        return this.translateDNA(dnaseq, this.codon1);
    }

    public String translateDNA3(String dnaseq) {
        return this.translateDNA(dnaseq, this.codon3);
    }

    public String toLong(String shortAASeq) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < shortAASeq.length(); ++i) {
            result.append((String)this.shortToLong.get((Object)shortAASeq.substring(i, i + 1)));
        }
        return result.toString();
    }

    public String toLong(char c) {
        return (String)this.shortToLong.get((Object)("" + c));
    }

    private String translateDNA(String dnaseq, ImmutableMap<String, String> codonTable) {
        StringBuilder aminoAcidSeq = new StringBuilder();
        int len = dnaseq.length();
        if (len % 3 != 0) {
            len -= len % 3;
        }
        for (int i = 0; i < len; i += 3) {
            String nt3 = dnaseq.substring(i, i + 3);
            String aa = (String)codonTable.get((Object)nt3);
            if (aa == null) {
                if (!nt3.contains("N")) break;
                aa = "X";
            }
            aminoAcidSeq.append(aa);
        }
        return aminoAcidSeq.toString();
    }

    private void initializeMaps() {
        ImmutableMap.Builder codon1 = new ImmutableMap.Builder();
        ImmutableMap.Builder codon3 = new ImmutableMap.Builder();
        ImmutableMap.Builder iupac = new ImmutableMap.Builder();
        ImmutableMap.Builder shortToLong = new ImmutableMap.Builder();
        ImmutableMap.Builder longToShort = new ImmutableMap.Builder();
        codon1.put((Object)"AAA", (Object)"K");
        codon1.put((Object)"AAC", (Object)"N");
        codon1.put((Object)"AAG", (Object)"K");
        codon1.put((Object)"AAT", (Object)"N");
        codon1.put((Object)"ACA", (Object)"T");
        codon1.put((Object)"ACC", (Object)"T");
        codon1.put((Object)"ACG", (Object)"T");
        codon1.put((Object)"ACT", (Object)"T");
        codon1.put((Object)"AGA", (Object)"R");
        codon1.put((Object)"AGC", (Object)"S");
        codon1.put((Object)"AGG", (Object)"R");
        codon1.put((Object)"AGT", (Object)"S");
        codon1.put((Object)"ATA", (Object)"I");
        codon1.put((Object)"ATC", (Object)"I");
        codon1.put((Object)"ATG", (Object)"M");
        codon1.put((Object)"ATT", (Object)"I");
        codon1.put((Object)"CAA", (Object)"Q");
        codon1.put((Object)"CAC", (Object)"H");
        codon1.put((Object)"CAG", (Object)"Q");
        codon1.put((Object)"CAT", (Object)"H");
        codon1.put((Object)"CCA", (Object)"P");
        codon1.put((Object)"CCC", (Object)"P");
        codon1.put((Object)"CCG", (Object)"P");
        codon1.put((Object)"CCT", (Object)"P");
        codon1.put((Object)"CGA", (Object)"R");
        codon1.put((Object)"CGC", (Object)"R");
        codon1.put((Object)"CGG", (Object)"R");
        codon1.put((Object)"CGT", (Object)"R");
        codon1.put((Object)"CTA", (Object)"L");
        codon1.put((Object)"CTC", (Object)"L");
        codon1.put((Object)"CTG", (Object)"L");
        codon1.put((Object)"CTT", (Object)"L");
        codon1.put((Object)"GAA", (Object)"E");
        codon1.put((Object)"GAC", (Object)"D");
        codon1.put((Object)"GAG", (Object)"E");
        codon1.put((Object)"GAT", (Object)"D");
        codon1.put((Object)"GCA", (Object)"A");
        codon1.put((Object)"GCC", (Object)"A");
        codon1.put((Object)"GCG", (Object)"A");
        codon1.put((Object)"GCT", (Object)"A");
        codon1.put((Object)"GGA", (Object)"G");
        codon1.put((Object)"GGC", (Object)"G");
        codon1.put((Object)"GGG", (Object)"G");
        codon1.put((Object)"GGT", (Object)"G");
        codon1.put((Object)"GTA", (Object)"V");
        codon1.put((Object)"GTC", (Object)"V");
        codon1.put((Object)"GTG", (Object)"V");
        codon1.put((Object)"GTT", (Object)"V");
        codon1.put((Object)"TAA", (Object)"*");
        codon1.put((Object)"TAC", (Object)"Y");
        codon1.put((Object)"TAG", (Object)"*");
        codon1.put((Object)"TAT", (Object)"Y");
        codon1.put((Object)"TCA", (Object)"S");
        codon1.put((Object)"TCC", (Object)"S");
        codon1.put((Object)"TCG", (Object)"S");
        codon1.put((Object)"TCT", (Object)"S");
        codon1.put((Object)"TGA", (Object)"*");
        codon1.put((Object)"TGC", (Object)"C");
        codon1.put((Object)"TGG", (Object)"W");
        codon1.put((Object)"TGT", (Object)"C");
        codon1.put((Object)"TTA", (Object)"L");
        codon1.put((Object)"TTC", (Object)"F");
        codon1.put((Object)"TTG", (Object)"L");
        codon1.put((Object)"TTT", (Object)"F");
        codon3.put((Object)"AAA", (Object)"Lys");
        codon3.put((Object)"AAC", (Object)"Asn");
        codon3.put((Object)"AAG", (Object)"Lys");
        codon3.put((Object)"AAT", (Object)"Asn");
        codon3.put((Object)"ACA", (Object)"Thr");
        codon3.put((Object)"ACC", (Object)"Thr");
        codon3.put((Object)"ACG", (Object)"Thr");
        codon3.put((Object)"ACT", (Object)"Thr");
        codon3.put((Object)"AGA", (Object)"Arg");
        codon3.put((Object)"AGC", (Object)"Ser");
        codon3.put((Object)"AGG", (Object)"Arg");
        codon3.put((Object)"AGT", (Object)"Ser");
        codon3.put((Object)"ATA", (Object)"Ile");
        codon3.put((Object)"ATC", (Object)"Ile");
        codon3.put((Object)"ATG", (Object)"Met");
        codon3.put((Object)"ATT", (Object)"Ile");
        codon3.put((Object)"CAA", (Object)"Gln");
        codon3.put((Object)"CAC", (Object)"His");
        codon3.put((Object)"CAG", (Object)"Gln");
        codon3.put((Object)"CAT", (Object)"His");
        codon3.put((Object)"CCA", (Object)"Pro");
        codon3.put((Object)"CCC", (Object)"Pro");
        codon3.put((Object)"CCG", (Object)"Pro");
        codon3.put((Object)"CCT", (Object)"Pro");
        codon3.put((Object)"CGA", (Object)"Arg");
        codon3.put((Object)"CGC", (Object)"Arg");
        codon3.put((Object)"CGG", (Object)"Arg");
        codon3.put((Object)"CGT", (Object)"Arg");
        codon3.put((Object)"CTA", (Object)"Leu");
        codon3.put((Object)"CTC", (Object)"Leu");
        codon3.put((Object)"CTG", (Object)"Leu");
        codon3.put((Object)"CTT", (Object)"Leu");
        codon3.put((Object)"GAA", (Object)"Glu");
        codon3.put((Object)"GAC", (Object)"Asp");
        codon3.put((Object)"GAG", (Object)"Glu");
        codon3.put((Object)"GAT", (Object)"Asp");
        codon3.put((Object)"GCA", (Object)"Ala");
        codon3.put((Object)"GCC", (Object)"Ala");
        codon3.put((Object)"GCG", (Object)"Ala");
        codon3.put((Object)"GCT", (Object)"Ala");
        codon3.put((Object)"GGA", (Object)"Gly");
        codon3.put((Object)"GGC", (Object)"Gly");
        codon3.put((Object)"GGG", (Object)"Gly");
        codon3.put((Object)"GGT", (Object)"Gly");
        codon3.put((Object)"GTA", (Object)"Val");
        codon3.put((Object)"GTC", (Object)"Val");
        codon3.put((Object)"GTG", (Object)"Val");
        codon3.put((Object)"GTT", (Object)"Val");
        codon3.put((Object)"TAA", (Object)"*");
        codon3.put((Object)"TAC", (Object)"Tyr");
        codon3.put((Object)"TAG", (Object)"*");
        codon3.put((Object)"TAT", (Object)"Tyr");
        codon3.put((Object)"TCA", (Object)"Ser");
        codon3.put((Object)"TCC", (Object)"Ser");
        codon3.put((Object)"TCG", (Object)"Ser");
        codon3.put((Object)"TCT", (Object)"Ser");
        codon3.put((Object)"TGA", (Object)"*");
        codon3.put((Object)"TGC", (Object)"Cys");
        codon3.put((Object)"TGG", (Object)"Trp");
        codon3.put((Object)"TGT", (Object)"Cys");
        codon3.put((Object)"TTA", (Object)"Leu");
        codon3.put((Object)"TTC", (Object)"Phe");
        codon3.put((Object)"TTG", (Object)"Leu");
        codon3.put((Object)"TTT", (Object)"Phe");
        iupac.put((Object)"-", (Object)"-");
        iupac.put((Object)".", (Object)"-");
        iupac.put((Object)"A", (Object)"AA");
        iupac.put((Object)"B", (Object)"CGT");
        iupac.put((Object)"C", (Object)"CC");
        iupac.put((Object)"D", (Object)"AGT");
        iupac.put((Object)"G", (Object)"GG");
        iupac.put((Object)"H", (Object)"ACT");
        iupac.put((Object)"K", (Object)"GT");
        iupac.put((Object)"M", (Object)"AC");
        iupac.put((Object)"N", (Object)"ACGT");
        iupac.put((Object)"R", (Object)"AG");
        iupac.put((Object)"S", (Object)"GC");
        iupac.put((Object)"T", (Object)"TT");
        iupac.put((Object)"V", (Object)"ACG");
        iupac.put((Object)"W", (Object)"AT");
        iupac.put((Object)"Y", (Object)"CT");
        longToShort.put((Object)"Ala", (Object)"A");
        longToShort.put((Object)"Cys", (Object)"C");
        longToShort.put((Object)"Asp", (Object)"D");
        longToShort.put((Object)"Glu", (Object)"E");
        longToShort.put((Object)"Phe", (Object)"F");
        longToShort.put((Object)"Gly", (Object)"G");
        longToShort.put((Object)"His", (Object)"H");
        longToShort.put((Object)"Ile", (Object)"I");
        longToShort.put((Object)"Lys", (Object)"K");
        longToShort.put((Object)"Leu", (Object)"L");
        longToShort.put((Object)"Met", (Object)"M");
        longToShort.put((Object)"Asn", (Object)"N");
        longToShort.put((Object)"Pyl", (Object)"O");
        longToShort.put((Object)"Pro", (Object)"P");
        longToShort.put((Object)"Gln", (Object)"Q");
        longToShort.put((Object)"Arg", (Object)"R");
        longToShort.put((Object)"Ser", (Object)"S");
        longToShort.put((Object)"Thr", (Object)"T");
        longToShort.put((Object)"Sec", (Object)"U");
        longToShort.put((Object)"Val", (Object)"V");
        longToShort.put((Object)"Trp", (Object)"W");
        longToShort.put((Object)"Tyr", (Object)"Y");
        longToShort.put((Object)"*", (Object)"*");
        this.longToShort = longToShort.build();
        for (Map.Entry entry : this.longToShort.entrySet()) {
            shortToLong.put((Object)((String)entry.getValue()), (Object)((String)entry.getKey()));
        }
        this.codon1 = codon1.build();
        this.codon3 = codon3.build();
        this.iupac = iupac.build();
        this.shortToLong = shortToLong.build();
    }
}

