/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs;

public enum VariantConfiguration {
    SINGLE_ORIGIN,
    IN_CIS,
    UNKNOWN_CIS_TRANS,
    MOSAIC,
    CHIMERIC;


    public static VariantConfiguration fromString(String s) {
        switch (s) {
            case ",": {
                return SINGLE_ORIGIN;
            }
            case "//": {
                return CHIMERIC;
            }
            case ";": {
                return IN_CIS;
            }
            case "(;)": {
                return UNKNOWN_CIS_TRANS;
            }
            case "/": {
                return MOSAIC;
            }
        }
        throw new RuntimeException("No VariantConfiguration known for string " + s);
    }

    public String toHGVSSeparator() {
        switch (this) {
            case SINGLE_ORIGIN: {
                return ",";
            }
            case CHIMERIC: {
                return "//";
            }
            case IN_CIS: {
                return ";";
            }
            case UNKNOWN_CIS_TRANS: {
                return "(;)";
            }
            case MOSAIC: {
                return "/";
            }
        }
        throw new RuntimeException("Unhandled VariantConfiguration " + (Object)((Object)this));
    }
}

