/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.legacy;

import com.google.common.base.Joiner;
import de.charite.compbio.jannovar.hgvs.legacy.LegacyLocationType;

public class LegacyLocation {
    private final LegacyLocationType locationType;
    private final int featureNo;
    private final int baseOffset;

    public static LegacyLocation buildIntronicLocation(int intronNo, int baseOffset) {
        return new LegacyLocation(LegacyLocationType.INTRONIC, intronNo, baseOffset);
    }

    public static LegacyLocation buildExonicLocation(int exonNo, int baseOffset) {
        return new LegacyLocation(LegacyLocationType.EXONIC, exonNo, baseOffset);
    }

    public LegacyLocation(LegacyLocationType locationType, int featureNo, int baseOffset) {
        this.locationType = locationType;
        this.featureNo = featureNo;
        this.baseOffset = baseOffset;
    }

    public LegacyLocationType getLocationType() {
        return this.locationType;
    }

    public int getFeatureNo() {
        return this.featureNo;
    }

    public int getBaseOffset() {
        return this.baseOffset;
    }

    public String toLegacyString() {
        String maybePlus = this.baseOffset > 0 ? "+" : "";
        return Joiner.on((String)"").skipNulls().join((Object)this.locationType.getLegacyString(), (Object)this.featureNo, new Object[]{maybePlus, this.baseOffset});
    }

    public String toString() {
        return "LegacyLocation [locationType=" + (Object)((Object)this.locationType) + ", featureNo=" + this.featureNo + ", baseOffset=" + this.baseOffset + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.baseOffset;
        result = 31 * result + this.featureNo;
        result = 31 * result + (this.locationType == null ? 0 : this.locationType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LegacyLocation other = (LegacyLocation)obj;
        if (this.baseOffset != other.baseOffset) {
            return false;
        }
        if (this.featureNo != other.featureNo) {
            return false;
        }
        return this.locationType == other.locationType;
    }
}

