/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.nts;

import com.google.common.base.Joiner;
import de.charite.compbio.jannovar.hgvs.AminoAcidCode;
import de.charite.compbio.jannovar.hgvs.ConvertibleToHGVSString;
import de.charite.compbio.jannovar.hgvs.nts.NucleotidePointLocation;

public class NucleotideRange
implements ConvertibleToHGVSString {
    private final NucleotidePointLocation firstPos;
    private final NucleotidePointLocation lastPos;

    public static NucleotideRange build(int firstPos, int firstPosOffset, int lastPos, int lastPosOffset) {
        return new NucleotideRange(NucleotidePointLocation.buildWithOffset(firstPos, firstPosOffset), NucleotidePointLocation.buildWithOffset(lastPos, lastPosOffset));
    }

    public static NucleotideRange buildWithoutOffset(int firstPos, int lastPos) {
        return new NucleotideRange(NucleotidePointLocation.build(firstPos), NucleotidePointLocation.build(lastPos));
    }

    public NucleotideRange(NucleotidePointLocation firstPos, NucleotidePointLocation lastPost) {
        this.firstPos = firstPos;
        this.lastPos = lastPost;
    }

    public NucleotidePointLocation getFirstPos() {
        return this.firstPos;
    }

    public NucleotidePointLocation getLastPos() {
        return this.lastPos;
    }

    @Override
    public String toHGVSString() {
        if (this.firstPos.equals(this.lastPos)) {
            return this.firstPos.toHGVSString();
        }
        return Joiner.on((String)"").join((Object)this.firstPos.toHGVSString(), (Object)"_", new Object[]{this.lastPos.toHGVSString()});
    }

    @Override
    public String toHGVSString(AminoAcidCode code) {
        return this.toHGVSString();
    }

    public String toString() {
        return "NucleotideRange [firstPos=" + this.firstPos + ", lastPos=" + this.lastPos + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.firstPos == null ? 0 : this.firstPos.hashCode());
        result = 31 * result + (this.lastPos == null ? 0 : this.lastPos.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NucleotideRange other = (NucleotideRange)obj;
        if (this.firstPos == null ? other.firstPos != null : !this.firstPos.equals(other.firstPos)) {
            return false;
        }
        return !(this.lastPos == null ? other.lastPos != null : !this.lastPos.equals(other.lastPos));
    }
}

