/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.nts.change;

import com.google.common.base.Joiner;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideRange;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideSeqDescription;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideChange;

public class NucleotideIndel
extends NucleotideChange {
    private final NucleotideRange range;
    private final NucleotideSeqDescription delSeq;
    private final NucleotideSeqDescription insSeq;

    public static NucleotideIndel buildWithOffsetWithoutSeqDescription(boolean onlyPredicted, int firstPos, int firstOffset, int lastPos, int lastOffset) {
        return new NucleotideIndel(onlyPredicted, NucleotideRange.build(firstPos, firstOffset, lastPos, lastOffset), new NucleotideSeqDescription(), new NucleotideSeqDescription());
    }

    public static NucleotideIndel buildWithOffsetWithLength(boolean onlyPredicted, int firstPos, int firstOffset, int lastPos, int lastOffset, int deletedLength, int insertedLength) {
        return new NucleotideIndel(onlyPredicted, NucleotideRange.build(firstPos, firstOffset, lastPos, lastOffset), new NucleotideSeqDescription(deletedLength), new NucleotideSeqDescription(insertedLength));
    }

    public static NucleotideIndel buildWithOffsetWithSequence(boolean onlyPredicted, int firstPos, int firstOffset, int lastPos, int lastOffset, String deletedSeq, String insertedSeq) {
        return new NucleotideIndel(onlyPredicted, NucleotideRange.build(firstPos, firstOffset, lastPos, lastOffset), new NucleotideSeqDescription(deletedSeq), new NucleotideSeqDescription(insertedSeq));
    }

    public static NucleotideIndel buildWithOffsetWithSeqDescription(boolean onlyPredicted, int firstPos, int firstOffset, int lastPos, int lastOffset, NucleotideSeqDescription delDesc, NucleotideSeqDescription insDesc) {
        return new NucleotideIndel(onlyPredicted, NucleotideRange.build(firstPos, firstOffset, lastPos, lastOffset), delDesc, insDesc);
    }

    public static NucleotideIndel buildWithoutSeqDescription(boolean onlyPredicted, int firstPos, int lastPos) {
        return new NucleotideIndel(onlyPredicted, NucleotideRange.buildWithoutOffset(firstPos, lastPos), new NucleotideSeqDescription(), new NucleotideSeqDescription());
    }

    public static NucleotideIndel buildWithLength(boolean onlyPredicted, int firstPos, int lastPos, int deletedLength, int insertedLength) {
        return new NucleotideIndel(onlyPredicted, NucleotideRange.buildWithoutOffset(firstPos, lastPos), new NucleotideSeqDescription(deletedLength), new NucleotideSeqDescription(insertedLength));
    }

    public static NucleotideIndel buildWithSequence(boolean onlyPredicted, int firstPos, int lastPos, String deletedSeq, String insertedSeq) {
        return new NucleotideIndel(onlyPredicted, NucleotideRange.buildWithoutOffset(firstPos, lastPos), new NucleotideSeqDescription(deletedSeq), new NucleotideSeqDescription(insertedSeq));
    }

    public static NucleotideIndel buildWithSeqDescription(boolean onlyPredicted, int firstPos, int lastPos, NucleotideSeqDescription delDesc, NucleotideSeqDescription insDesc) {
        return new NucleotideIndel(onlyPredicted, NucleotideRange.buildWithoutOffset(firstPos, lastPos), delDesc, insDesc);
    }

    public NucleotideIndel(boolean onlyPredicted, NucleotideRange range, NucleotideSeqDescription delSeq, NucleotideSeqDescription insSeq) {
        super(onlyPredicted);
        this.range = range;
        this.delSeq = delSeq;
        this.insSeq = insSeq;
    }

    @Override
    public NucleotideIndel withOnlyPredicted(boolean flag) {
        return new NucleotideIndel(flag, this.range, this.delSeq, this.insSeq);
    }

    @Override
    public String toHGVSString() {
        String open = this.isOnlyPredicted() ? "(" : "";
        String close = this.isOnlyPredicted() ? ")" : "";
        return Joiner.on((String)"").skipNulls().join((Object)open, (Object)this.range.toHGVSString(), new Object[]{"del", this.delSeq.toHGVSString(), "ins", this.insSeq.toHGVSString(), close});
    }

    public String toString() {
        return "NucleotideIndel [range=" + this.range + ", delSeq=" + this.delSeq + ", insSeq=" + this.insSeq + "]";
    }

    public NucleotideRange getRange() {
        return this.range;
    }

    public NucleotideSeqDescription getInsSeq() {
        return this.insSeq;
    }

    public NucleotideSeqDescription getDelSeq() {
        return this.delSeq;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delSeq == null ? 0 : this.delSeq.hashCode());
        result = 31 * result + (this.insSeq == null ? 0 : this.insSeq.hashCode());
        result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NucleotideIndel other = (NucleotideIndel)obj;
        if (this.delSeq == null ? other.delSeq != null : !this.delSeq.equals(other.delSeq)) {
            return false;
        }
        if (this.insSeq == null ? other.insSeq != null : !this.insSeq.equals(other.insSeq)) {
            return false;
        }
        return !(this.range == null ? other.range != null : !this.range.equals(other.range));
    }
}

