/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.nts.change;

import de.charite.compbio.jannovar.hgvs.nts.NucleotideRange;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideSeqDescription;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideChange;

public class NucleotideInsertion
extends NucleotideChange {
    private final NucleotideRange range;
    private final NucleotideSeqDescription seq;

    public static NucleotideInsertion buildWithOffsetWithoutSeqDescription(boolean onlyPredicted, int firstPos, int firstOffset, int lastPos, int lastOffset) {
        return new NucleotideInsertion(onlyPredicted, NucleotideRange.build(firstPos, firstOffset, lastPos, lastOffset), new NucleotideSeqDescription());
    }

    public static NucleotideInsertion buildWithOffsetWithLength(boolean onlyPredicted, int firstPos, int firstOffset, int lastPos, int lastOffset, int insertedLength) {
        return new NucleotideInsertion(onlyPredicted, NucleotideRange.build(firstPos, firstOffset, lastPos, lastOffset), new NucleotideSeqDescription(insertedLength));
    }

    public static NucleotideInsertion buildWithOffsetWithSequence(boolean onlyPredicted, int firstPos, int firstOffset, int lastPos, int lastOffset, String seq) {
        return new NucleotideInsertion(onlyPredicted, NucleotideRange.build(firstPos, firstOffset, lastPos, lastOffset), new NucleotideSeqDescription(seq));
    }

    public static NucleotideInsertion buildWithLength(boolean onlyPredicted, int firstPos, int lastPos) {
        return new NucleotideInsertion(onlyPredicted, NucleotideRange.buildWithoutOffset(firstPos, lastPos), new NucleotideSeqDescription());
    }

    public static NucleotideInsertion buildWithLength(boolean onlyPredicted, int firstPos, int lastPos, int insertedLength) {
        return new NucleotideInsertion(onlyPredicted, NucleotideRange.buildWithoutOffset(firstPos, lastPos), new NucleotideSeqDescription(insertedLength));
    }

    public static NucleotideInsertion buildWithSequence(boolean onlyPredicted, int firstPos, int lastPos, String seq) {
        return new NucleotideInsertion(onlyPredicted, NucleotideRange.buildWithoutOffset(firstPos, lastPos), new NucleotideSeqDescription(seq));
    }

    public NucleotideInsertion(boolean onlyPredicted, NucleotideRange position, NucleotideSeqDescription seq) {
        super(onlyPredicted);
        this.range = position;
        this.seq = seq;
    }

    public NucleotideRange getRange() {
        return this.range;
    }

    public NucleotideSeqDescription getSeq() {
        return this.seq;
    }

    @Override
    public NucleotideInsertion withOnlyPredicted(boolean flag) {
        return new NucleotideInsertion(flag, this.range, this.seq);
    }

    @Override
    public String toHGVSString() {
        return this.wrapIfOnlyPredicted(this.range.toHGVSString() + "ins" + this.seq.toHGVSString());
    }

    public String toString() {
        return "NucleotideInsertion [position=" + this.range + ", seq=" + this.seq + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
        result = 31 * result + (this.seq == null ? 0 : this.seq.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NucleotideInsertion other = (NucleotideInsertion)obj;
        if (this.range == null ? other.range != null : !this.range.equals(other.range)) {
            return false;
        }
        return !(this.seq == null ? other.seq != null : !this.seq.equals(other.seq));
    }
}

