/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.nts.change;

import com.google.common.base.Joiner;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideRange;
import de.charite.compbio.jannovar.hgvs.nts.NucleotideSeqDescription;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideChange;

public class NucleotideInversion
extends NucleotideChange {
    private final NucleotideRange range;
    private final NucleotideSeqDescription seq;

    public static NucleotideInversion buildWithOffset(boolean onlyPredicted, int firstPos, int firstPosOffset, int lastPos, int lastPosOffset, NucleotideSeqDescription seq) {
        return new NucleotideInversion(onlyPredicted, NucleotideRange.build(firstPos, firstPosOffset, lastPos, lastPosOffset), seq);
    }

    public static NucleotideInversion buildWithOffsetWithSequence(boolean onlyPredicted, int firstPos, int firstPosOffset, int lastPos, int lastPosOffset, String nts) {
        return new NucleotideInversion(onlyPredicted, NucleotideRange.build(firstPos, firstPosOffset, lastPos, lastPosOffset), new NucleotideSeqDescription(nts));
    }

    public static NucleotideInversion buildWithOffsetWithLength(boolean onlyPredicted, int firstPos, int firstPosOffset, int lastPos, int lastPosOffset, int seqLen) {
        return new NucleotideInversion(onlyPredicted, NucleotideRange.build(firstPos, firstPosOffset, lastPos, lastPosOffset), new NucleotideSeqDescription(seqLen));
    }

    public static NucleotideInversion buildWithOffsetWithoutSeqDescription(boolean onlyPredicted, int firstPos, int firstPosOffset, int lastPos, int lastPosOffset) {
        return new NucleotideInversion(onlyPredicted, NucleotideRange.build(firstPos, firstPosOffset, lastPos, lastPosOffset), new NucleotideSeqDescription());
    }

    public static NucleotideInversion build(boolean onlyPredicted, int firstPos, int lastPos, NucleotideSeqDescription seq) {
        return new NucleotideInversion(onlyPredicted, NucleotideRange.buildWithoutOffset(firstPos, lastPos), seq);
    }

    public static NucleotideInversion buildWithSequence(boolean onlyPredicted, int firstPos, int lastPos, String nts) {
        return new NucleotideInversion(onlyPredicted, NucleotideRange.buildWithoutOffset(firstPos, lastPos), new NucleotideSeqDescription(nts));
    }

    public static NucleotideInversion buildWithLength(boolean onlyPredicted, int firstPos, int lastPos, int seqLen) {
        return new NucleotideInversion(onlyPredicted, NucleotideRange.buildWithoutOffset(firstPos, lastPos), new NucleotideSeqDescription(seqLen));
    }

    public static NucleotideInversion buildWithoutSeqDescription(boolean onlyPredicted, int firstPos, int lastPos) {
        return new NucleotideInversion(onlyPredicted, NucleotideRange.buildWithoutOffset(firstPos, lastPos), new NucleotideSeqDescription());
    }

    public NucleotideInversion(boolean onlyPredicted, NucleotideRange range, NucleotideSeqDescription seq) {
        super(onlyPredicted);
        this.range = range;
        this.seq = seq;
    }

    @Override
    public NucleotideInversion withOnlyPredicted(boolean flag) {
        return new NucleotideInversion(flag, this.range, this.seq);
    }

    public NucleotideRange getRange() {
        return this.range;
    }

    public NucleotideSeqDescription getSeq() {
        return this.seq;
    }

    @Override
    public String toHGVSString() {
        return this.wrapIfOnlyPredicted(Joiner.on((String)"").join((Object)this.range.toHGVSString(), (Object)"inv", new Object[]{this.seq.toHGVSString()}));
    }

    public String toString() {
        return "NucleotideInversion [range=" + this.range + ", seq=" + this.seq + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
        result = 31 * result + (this.seq == null ? 0 : this.seq.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NucleotideInversion other = (NucleotideInversion)obj;
        if (this.range == null ? other.range != null : !this.range.equals(other.range)) {
            return false;
        }
        return !(this.seq == null ? other.seq != null : !this.seq.equals(other.seq));
    }
}

