/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.nts.change;

import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideChange;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideMiscChangeType;

public class NucleotideMiscChange
extends NucleotideChange {
    private final NucleotideMiscChangeType changeType;

    public static NucleotideMiscChange build(boolean onlyPredicted, NucleotideMiscChangeType changeType) {
        return new NucleotideMiscChange(onlyPredicted, changeType);
    }

    public static NucleotideMiscChange buildFromString(String str) {
        if (str.equals("(?)")) {
            return NucleotideMiscChange.build(false, NucleotideMiscChangeType.SAME_AS_DNA);
        }
        if (str.equals("?")) {
            return NucleotideMiscChange.build(false, NucleotideMiscChangeType.UNKNOWN_EFFECT);
        }
        if (str.equals("(spl?)")) {
            return NucleotideMiscChange.build(true, NucleotideMiscChangeType.SPLICING_AFFECTED);
        }
        if (str.equals("spl?")) {
            return NucleotideMiscChange.build(false, NucleotideMiscChangeType.SPLICING_AFFECTED);
        }
        if (str.equals("(=)")) {
            return NucleotideMiscChange.build(true, NucleotideMiscChangeType.NO_CHANGE);
        }
        if (str.equals("=")) {
            return NucleotideMiscChange.build(false, NucleotideMiscChangeType.NO_CHANGE);
        }
        if (str.equals("(0)")) {
            return NucleotideMiscChange.build(true, NucleotideMiscChangeType.NO_RNA);
        }
        if (str.equals("0")) {
            return NucleotideMiscChange.build(false, NucleotideMiscChangeType.NO_RNA);
        }
        throw new IllegalArgumentException("Invalid nucleotide misc change string " + str);
    }

    public NucleotideMiscChange(boolean onlyPredicted, NucleotideMiscChangeType changeType) {
        super(onlyPredicted);
        this.changeType = changeType;
    }

    @Override
    public NucleotideMiscChange withOnlyPredicted(boolean flag) {
        return new NucleotideMiscChange(flag, this.changeType);
    }

    public NucleotideMiscChangeType getChangeType() {
        return this.changeType;
    }

    @Override
    public String toHGVSString() {
        return this.changeType.toHGVSString(this.isOnlyPredicted());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.changeType == null ? 0 : this.changeType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NucleotideMiscChange other = (NucleotideMiscChange)obj;
        return this.changeType == other.changeType;
    }
}

