/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.nts.change;

import com.google.common.base.Joiner;
import de.charite.compbio.jannovar.hgvs.nts.NucleotidePointLocation;
import de.charite.compbio.jannovar.hgvs.nts.change.NucleotideChange;

public class NucleotideSubstitution
extends NucleotideChange {
    private final NucleotidePointLocation position;
    private final String fromNT;
    private final String toNT;

    public static NucleotideSubstitution buildWithOffset(boolean onlyPredicted, int basePos, int posOffset, String fromNT, String toNT) {
        return new NucleotideSubstitution(onlyPredicted, NucleotidePointLocation.buildWithOffset(basePos, posOffset), fromNT, toNT);
    }

    public static NucleotideSubstitution build(boolean onlyPredicted, int basePos, String fromNT, String toNT) {
        return new NucleotideSubstitution(onlyPredicted, NucleotidePointLocation.build(basePos), fromNT, toNT);
    }

    public NucleotideSubstitution(boolean onlyPredicted, NucleotidePointLocation position, String fromNT, String toNT) {
        super(onlyPredicted);
        this.position = position;
        this.fromNT = fromNT;
        this.toNT = toNT;
    }

    @Override
    public NucleotideSubstitution withOnlyPredicted(boolean flag) {
        return new NucleotideSubstitution(flag, this.position, this.fromNT, this.toNT);
    }

    public NucleotidePointLocation getPosition() {
        return this.position;
    }

    public String getFromNT() {
        return this.fromNT;
    }

    public String getToNT() {
        return this.toNT;
    }

    @Override
    public String toHGVSString() {
        return this.wrapIfOnlyPredicted(Joiner.on((String)"").join((Object)this.position.toHGVSString(), (Object)this.fromNT, new Object[]{">", this.toNT}));
    }

    public String toString() {
        return "NucleotideSubstitution [position=" + this.position + ", fromNT=" + this.fromNT + ", toNT=" + this.toNT + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fromNT == null ? 0 : this.fromNT.hashCode());
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        result = 31 * result + (this.toNT == null ? 0 : this.toNT.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NucleotideSubstitution other = (NucleotideSubstitution)obj;
        if (this.fromNT == null ? other.fromNT != null : !this.fromNT.equals(other.fromNT)) {
            return false;
        }
        if (this.position == null ? other.position != null : !this.position.equals(other.position)) {
            return false;
        }
        return !(this.toNT == null ? other.toNT != null : !this.toNT.equals(other.toNT));
    }
}

