/*
 * Decompiled with CFR 0.152.
 */
package de.charite.compbio.jannovar.hgvs.nts.variant;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import de.charite.compbio.jannovar.hgvs.SequenceType;
import de.charite.compbio.jannovar.hgvs.nts.variant.NucleotideChangeAllele;
import de.charite.compbio.jannovar.hgvs.nts.variant.NucleotideVariant;
import java.util.ArrayList;
import java.util.Collection;

public class MultiAlleleNucleotideVariant
extends NucleotideVariant {
    protected final ImmutableList<NucleotideChangeAllele> alleles;

    public static MultiAlleleNucleotideVariant build(SequenceType seqType, String seqID, NucleotideChangeAllele ... alleles) {
        return new MultiAlleleNucleotideVariant(seqType, seqID, (Collection<NucleotideChangeAllele>)ImmutableList.copyOf((Object[])alleles));
    }

    public MultiAlleleNucleotideVariant(SequenceType seqType, String refID, String proteinID, int transcriptVersion, Collection<NucleotideChangeAllele> alleles) {
        super(seqType, refID, proteinID, transcriptVersion);
        this.alleles = ImmutableList.copyOf(alleles);
    }

    public MultiAlleleNucleotideVariant(SequenceType seqType, String seqID, Collection<NucleotideChangeAllele> alleles) {
        super(seqType, seqID);
        this.alleles = ImmutableList.copyOf(alleles);
    }

    public ImmutableList<NucleotideChangeAllele> getAlleles() {
        return this.alleles;
    }

    @Override
    public String toHGVSString() {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.getRefIDWithVersion());
        parts.add(":");
        parts.add(this.seqType.getPrefix());
        boolean first = true;
        for (NucleotideChangeAllele allele : this.alleles) {
            if (first) {
                first = false;
            } else {
                parts.add(";");
            }
            parts.add(allele.toHGVSString());
        }
        return Joiner.on((String)"").join(parts);
    }

    @Override
    public String toString() {
        return "MultiAlleleNucleotideVariant [alleles=" + this.alleles + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.alleles == null ? 0 : this.alleles.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiAlleleNucleotideVariant other = (MultiAlleleNucleotideVariant)obj;
        return !(this.alleles == null ? other.alleles != null : !this.alleles.equals(other.alleles));
    }
}

